<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Saldo_transaksi extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_saldo_transaksi', 'saldo_transaksi');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_transaksi');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Transaksi Saldo User';

        $this->template->load('includes/header', 'view_saldo_transaksi', $data);
    }

    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        //SUKSES
        if (strlen($txt_cari) > 0) {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_sukses_total,
                                        count(trx_transaksi_kode) as statistik_sukses_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='1'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='1'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='1'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='1'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='1'
                                        and trx_transaksi_kategori='Deposit'");
        } else {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_sukses_total,
                                        count(trx_transaksi_kode) as statistik_sukses_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_transaksi_rc='1'
                                        and trx_transaksi_kategori='Deposit'");
        }

        if ($sukses->num_rows() > 0) {
            foreach ($sukses->result() as $row) {
                $data['statistik_sukses_total'] = number_format($row->statistik_sukses_total, 0, ',', '.');
                $data['statistik_sukses_jumlah'] = number_format($row->statistik_sukses_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_sukses_total'] = '0';
            $data['statistik_sukses_jumlah'] = '0';
        }

        //PENDING
        if (strlen($txt_cari) > 0) {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_pending_total,
                                        count(trx_transaksi_kode) as statistik_pending_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='0'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='0'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='0'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='0'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='0'
                                        and trx_transaksi_kategori='Deposit'");
        } else {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_pending_total,
                                        count(trx_transaksi_kode) as statistik_pending_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_transaksi_rc='0'
                                        and trx_transaksi_kategori='Deposit'");
        }

        if ($pending->num_rows() > 0) {
            foreach ($pending->result() as $row) {
                $data['statistik_pending_total'] = number_format($row->statistik_pending_total, 0, ',', '.');
                $data['statistik_pending_jumlah'] = number_format($row->statistik_pending_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_pending_total'] = '0';
            $data['statistik_pending_jumlah'] = '0';
        }

        //GAGAL
        if (strlen($txt_cari) > 0) {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_gagal_total,
                                        count(trx_transaksi_kode) as statistik_gagal_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc in ('2', '3')
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc in ('2', '3')
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc in ('2', '3')
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc in ('2', '3')
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc in ('2', '3')
                                        and trx_transaksi_kategori='Deposit'");
        } else {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_gagal_total,
                                        count(trx_transaksi_kode) as statistik_gagal_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_transaksi_rc in ('2', '3')");
        }

        if ($gagal->num_rows() > 0) {
            foreach ($gagal->result() as $row) {
                $data['statistik_gagal_total'] = number_format($row->statistik_gagal_total, 0, ',', '.');
                $data['statistik_gagal_jumlah'] = number_format($row->statistik_gagal_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_gagal_total'] = '0';
            $data['statistik_gagal_jumlah'] = '0';
        }

        //SEMUA
        if (strlen($txt_cari) > 0) {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_semua_total,
                                        count(trx_transaksi_kode) as statistik_semua_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%' 
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' 
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'
                                        and trx_transaksi_kategori='Deposit'
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'
                                        and trx_transaksi_kategori='Deposit'");
        } else {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_semua_total,
                                        count(trx_transaksi_kode) as statistik_semua_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_transaksi_kategori='Deposit'");
        }

        if ($semua->num_rows() > 0) {
            foreach ($semua->result() as $row) {
                $data['statistik_semua_total'] = number_format($row->statistik_semua_total, 0, ',', '.');
                $data['statistik_semua_jumlah'] = number_format($row->statistik_semua_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_semua_total'] = '0';
            $data['statistik_semua_jumlah'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_transaksi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->saldo_transaksi->get_datatables_cari($txt_cari);
        } else {
            $list = $this->saldo_transaksi->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            //STATUS
            $trx_transaksi_status = "<div class='btn btn-success'>$field->trx_transaksi_status</div>";
            $trx_transaksi_kategori = "<div class='btn btn-warning'>" . strtoupper($field->trx_transaksi_kategori) . "</div>";

            $row[] = $no;
            $row[] = $trx_transaksi_status;
            $row[] = $trx_transaksi_kategori;
            $row[] = $field->trx_transaksi_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->trx_transaksi_kode;
            $row[] = $field->trx_transaksi_nomor;
            $row[] = $field->trx_transaksi_nama;
            $row[] = number_format($field->trx_transaksi_jumlah, 0, ',', '.');
            $row[] = $field->trx_transaksi_keterangan;
            $row[] = $field->trx_transaksi_notasi;
            $row[] = date("d M Y H:i:s", strtotime($field->trx_transaksi_tanggal));
            $row[] = $field->trx_transaksi_rc;
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->saldo_transaksi->count_all_cari($txt_cari),
                "recordsFiltered" => $this->saldo_transaksi->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->saldo_transaksi->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->saldo_transaksi->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }
}
