<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Saldo_user extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_saldo_user', 'saldo_user');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_user');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Saldo User';

        $this->template->load('includes/header', 'view_saldo_user', $data);
    }


    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_user');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $txt_cari = $this->input->post("txt_cari");

        //SEMUA
        if (strlen($txt_cari) > 0) {
            $semua = $db_arifahpulsa_api->query("SELECT sum(mst_saldo_jumlah) as statistik_semua_total from tbl_mst_user,tbl_mst_saldo
                                        where
                                        mst_user_kode LIKE '%$txt_cari%' and
                                        mst_saldo_user_kode=mst_user_kode
                                        OR
                                        mst_user_nama_lengkap LIKE '%$txt_cari%' and
                                        mst_saldo_user_kode=mst_user_kode
                                        OR
                                        mst_user_nomor_hp LIKE '%$txt_cari%' and
                                        mst_saldo_user_kode=mst_user_kode
                                        OR
                                        mst_user_email LIKE '%$txt_cari%' and
                                        mst_saldo_user_kode=mst_user_kode");
        } else {
            $semua = $db_arifahpulsa_api->query("SELECT sum(mst_saldo_jumlah) as statistik_semua_total from tbl_mst_user,tbl_mst_saldo 
                                        where mst_saldo_user_kode=mst_user_kode");
        }

        if ($semua->num_rows() > 0) {
            foreach ($semua->result() as $row) {
                $data['statistik_semua_total'] = number_format($row->statistik_semua_total, 0, ',', '.');
            }
        } else {
            $data['statistik_semua_total'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_saldo()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_user');

        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->saldo_user->get_datatables_cari($txt_cari);
        } else {
            $list = $this->saldo_user->get_datatables();
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            if ($this->Model_squrity->cekmenu_saldo('saldo_user/tambah') == true) {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                        <a class='dropdown-item' onclick=aksi_tambah_saldo_user_modal(this)>TAMBAH SALDO</a>
                        </div>
                        </button>
                    </div>";
            } else {
                $aksi = " <button type='button' class='btn btn-danger'>AKSES PENGISAN SALDO MANUAL TIDAK ADA</button>";
            }



            $row[] = $no;
            $row[] = $aksi;
            $row[] = $field->mst_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->mst_user_nomor_hp;
            $row[] = $field->mst_user_email;
            $row[] = number_format($field->mst_saldo_jumlah, 0, ',', '.');
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->saldo_user->count_all_cari($txt_cari),
                "recordsFiltered" => $this->saldo_user->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->saldo_user->count_all(),
                "recordsFiltered" => $this->saldo_user->count_filtered(),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }

    function aksi_tambah_saldo_user()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_user/tambah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //USER
        $mst_user_kode = $this->input->post("mst_user_kode");

        //DEPOSIT
        $trx_deposit_kode = "DEPOSIT-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $trx_deposit_tanggal = date('Y-m-d H:i:s');
        $trx_deposit_jumlah = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("trx_deposit_jumlah"));
        $trx_deposit_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("trx_deposit_admin"));
        $trx_deposit_keterangan = "Pengisian saldo manual";
        $trx_deposit_icon =  $this->config->item('icon_deposit');

        //KATEGORI TRANSAKSI
        $trx_transaksi_kategori =  $this->config->item('transaksi_deposit');

        //NOTIFIKASI
        $mst_inbox_kode = "INBOX-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $notifikasi_judul = $this->input->post("notifikasi_judul");
        $notifikasi_isi = $this->input->post("notifikasi_isi");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //INSERT KE tbl_trx_deposit
            $db_arifahpulsa_api->query("insert into tbl_trx_deposit (
				trx_deposit_kode, 
				trx_deposit_user_kode, 
				trx_deposit_tripay_reference, 
				trx_deposit_metode, 
				trx_deposit_tanggal, 
				trx_deposit_jumlah, 
				trx_deposit_admin,
				trx_deposit_channel,
				trx_deposit_va,
				trx_deposit_link,
				trx_deposit_keterangan, 
				trx_deposit_notasi, 
				trx_deposit_icon, 
				trx_deposit_rc, 
				trx_deposit_status) values (
				'$trx_deposit_kode', 
				'$mst_user_kode', 
				'$trx_deposit_kode',
				'Manual',
				'$trx_deposit_tanggal', 
				'$trx_deposit_jumlah', 
				'$trx_deposit_admin',
				'Manual', 
				'Manual', 
				'Manual', 
				'$trx_deposit_keterangan', 
				'Penambahan saldo manual yang dilakukan oleh admin, jika terdapat kesalahan mohon menghubungi customer service!', 
				'$trx_deposit_icon', 
				'1', 
				'Sukses')");

            //INSERT KE tbl_trx_transaksi
            $db_arifahpulsa_api->query("insert into tbl_trx_transaksi (
				trx_transaksi_kode, 
				trx_transaksi_user_kode, 
				trx_transaksi_kategori, 
				trx_transaksi_nomor, 
				trx_transaksi_nama, 
				trx_transaksi_jumlah,
				trx_transaksi_keterangan,
				trx_transaksi_notasi, 
				trx_transaksi_tanggal, 
				trx_transaksi_icon, 
				trx_transaksi_rc,
				trx_transaksi_status) values (
				'$trx_deposit_kode', 
				'$mst_user_kode', 
				'$trx_transaksi_kategori', 
				'Manual',
				'Isi saldo', 
				'$trx_deposit_jumlah' + '$trx_deposit_admin', 
				'$trx_deposit_keterangan',
				'', 
				'$trx_deposit_tanggal', 
				'$trx_deposit_icon', 
				'1', 
				'Sukses')");

            //UPDATE tbl_mst_saldo
            $db_arifahpulsa_api->query("UPDATE tbl_mst_saldo set 
                                mst_saldo_jumlah=mst_saldo_jumlah + '$trx_deposit_jumlah'
                                where
                                mst_saldo_user_kode='$mst_user_kode'");

            //INSERT KE tbl_trx_pendapatan
            $db_arifahpulsa_api->query("insert into tbl_trx_pendapatan (
                                trx_pendapatan_kode, 
                                trx_pendapatan_user_kode, 
                                trx_pendapatan_kategori, 
                                trx_pendapatan_jumlah, 
                                trx_pendapatan_tanggal) values (
                                '$trx_deposit_kode', 
                                '$mst_user_kode', 
                                '$trx_transaksi_kategori',
                                '$trx_deposit_admin', 
                                '$trx_deposit_tanggal')");

            //INSERT KE tbl_mst_inbox
            $db_arifahpulsa_api->query("insert into tbl_mst_inbox (
                        mst_inbox_kode, 
                        mst_inbox_user_kode, 
                        mst_inbox_jenis, 
                        mst_inbox_judul, 
                        mst_inbox_isi,
                        mst_inbox_tanggal,
                        mst_inbox_jangka_waktu,
                        mst_inbox_status) values (
                        '$mst_inbox_kode', 
                        '$mst_user_kode', 
                        'Teks',
                        '" . str_replace("'", "\'", $notifikasi_judul) . "',
                        '" . str_replace("'", "\'", $notifikasi_isi) . "',
                        '$trx_deposit_tanggal',
                        '1',
                        '0')");

            //KIRIM NOTIFIKASI
            $title = $notifikasi_judul;
            $body =  strip_tags($notifikasi_isi);
            firebase_notification($title, $body, $mst_user_firebase);

            $data['saldo_status'] = '0';
            echo json_encode($data);
        } else {
            $data['saldo_status'] = '1';
            echo json_encode($data);
        }
    }
}
