<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Cron_pascabayar extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Jakarta");
    }

    public function index()
    {
        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'pasca',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ

            $buyer_sku_code = $data['buyer_sku_code'];
            $product_name = $data['product_name'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                if ($buyer_sku_code == 'pln_pascabayar') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan PLN dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-012'");
                } else if ($buyer_sku_code == 'bpjs_kesehatan') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan BPSJ Kesehatan dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-009'");
                } else if ($buyer_sku_code == 'gas_negara') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan gas negara dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-017'");
                } else {
                    $hp[] = array(
                        'ktg_hp_kode' => $buyer_sku_code,
                        'ktg_hp_keterangan' =>  'Nomor HP dibutuhkan untuk melakukan transaksi',
                        'ktg_hp_status' =>  '0'
                    );

                    $internet[] = array(
                        'ktg_internet_kode' => $buyer_sku_code,
                        'ktg_internet_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_internet_status' =>  '0'
                    );

                    $multifinance[] = array(
                        'ktg_multifinance_kode' => $buyer_sku_code,
                        'ktg_multifinance_keterangan' =>  'Nomor kontrak dibutuhkan untuk melakukan transaksi',
                        'ktg_multifinance_status' =>  '0'
                    );

                    $pbb[] = array(
                        'ktg_pbb_kode' => $buyer_sku_code,
                        'ktg_pbb_keterangan' =>  'Nomor objek pajak dibutuhkan untuk melakukan transaksi',
                        'ktg_pbb_status' =>  '0'
                    );

                    $pdam[] = array(
                        'ktg_pdam_kode' => $buyer_sku_code,
                        'ktg_pdam_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_pdam_status' =>  '0'
                    );

                    $tv[] = array(
                        'ktg_tv_kode' => $buyer_sku_code,
                        'ktg_tv_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_tv_status' =>  '0'
                    );
                }
            } else {
                if ($buyer_sku_code == 'pln_pascabayar') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran listrik pln mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-012'");
                } else if ($buyer_sku_code == 'bpjs_kesehatan') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran BPJS kesehatan mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-009'");
                } else if ($buyer_sku_code == 'gas_negara') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran Gas Negara mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-017'");
                } else {
                    $hp[] = array(
                        'ktg_hp_kode' => $buyer_sku_code,
                        'ktg_hp_keterangan' =>  'Pembayaran tagihan HP mengalami gangguan, silahkan coba secara berkala',
                        'ktg_hp_status' =>  '1'
                    );

                    $internet[] = array(
                        'ktg_internet_kode' => $buyer_sku_code,
                        'ktg_internet_keterangan' => 'Pembayaran tagihan internet mengalami gangguan, silahkan coba secara berkala',
                        'ktg_internet_status' =>  '1'
                    );

                    $multifinance[] = array(
                        'ktg_multifinance_kode' => $buyer_sku_code,
                        'ktg_multifinance_keterangan' =>  'Pembayaran tagihan kredit mengalami gangguan, silahkan coba secara berkala',
                        'ktg_multifinance_status' =>  '1'
                    );

                    $pbb[] = array(
                        'ktg_pbb_kode' => $buyer_sku_code,
                        'ktg_pbb_keterangan' =>  'Pembayaran pajak bumi dan bangunan mengalami gangguan, silahkan coba secara berkala',
                        'ktg_pbb_status' =>  '1'
                    );

                    $pdam[] = array(
                        'ktg_pdam_kode' => $buyer_sku_code,
                        'ktg_pdam_keterangan' =>  'Pembayaran tagihan PDAM mengalami gangguan, silahkan coba secara berkala',
                        'ktg_pdam_status' =>  '1'
                    );

                    $tv[] = array(
                        'ktg_tv_kode' => $buyer_sku_code,
                        'ktg_tv_keterangan' =>  'Pembayaran tagihan TV mengalami gangguan, silahkan coba secara berkala',
                        'ktg_tv_status' =>  '1'
                    );
                }
            }
        }

        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_ktg_hp', $hp, 'ktg_hp_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_internet', $internet, 'ktg_internet_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_multifinance', $multifinance, 'ktg_multifinance_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_pbb', $pbb, 'ktg_pbb_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_pdam', $pdam, 'ktg_pdam_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_tv', $tv, 'ktg_tv_kode');


        //LOG

        $log_file = APPPATH . 'logs/pascabayar.txt';
        $log_msg = date('Y-m-d H:i:s') . " - Cron pascabayar dijalankan\n";
        file_put_contents($log_file, '');
        file_put_contents($log_file, $log_msg, FILE_APPEND);
    }
}
