<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Transaksi_grab extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_transaksi_grab', 'transaksi_grab');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_grab');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Transaksi Grab';

        $this->template->load('includes/header', 'transaksi/view_transaksi_grab', $data);
    }


    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_grab');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        //SUKSES
        if (strlen($txt_cari) > 0) {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_sukses_total,
                                        count(trx_grab_kode) as statistik_sukses_jumlah from tbl_trx_grab
                                        where
                                        trx_grab_kode LIKE '%$txt_cari%'and 
                                        trx_grab_rc='00'
                                        OR
                                        trx_grab_nama LIKE '%$txt_cari%' and 
                                        trx_grab_rc='00'
                                        OR
                                        trx_grab_status LIKE '%$txt_cari%' and 
                                        trx_grab_rc='00'
                                        OR
                                        trx_grab_nomor LIKE '%$txt_cari%'and 
                                        trx_grab_rc='00'");
        } else {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_sukses_total,
                                        count(trx_grab_kode) as statistik_sukses_jumlah from tbl_trx_grab
                                        where trx_grab_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_grab_rc='00'");
        }

        if ($sukses->num_rows() > 0) {
            foreach ($sukses->result() as $row) {
                $data['statistik_sukses_total'] = number_format($row->statistik_sukses_total, 0, ',', '.');
                $data['statistik_sukses_jumlah'] = number_format($row->statistik_sukses_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_sukses_total'] = '0';
            $data['statistik_sukses_jumlah'] = '0';
        }

        //PENDING
        if (strlen($txt_cari) > 0) {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_pending_total,
                                        count(trx_grab_kode) as statistik_pending_jumlah from tbl_trx_grab
                                        where
                                        trx_grab_kode LIKE '%$txt_cari%'and 
                                        trx_grab_rc='03'
                                        OR
                                        trx_grab_nama LIKE '%$txt_cari%' and 
                                        trx_grab_rc='03'
                                        OR
                                        trx_grab_status LIKE '%$txt_cari%' and 
                                        trx_grab_rc='03'
                                        OR
                                        trx_grab_nomor LIKE '%$txt_cari%'and 
                                        trx_grab_rc='03'");
        } else {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_pending_total,
                                        count(trx_grab_kode) as statistik_pending_jumlah from tbl_trx_grab
                                        where trx_grab_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_grab_rc='03'");
        }

        if ($pending->num_rows() > 0) {
            foreach ($pending->result() as $row) {
                $data['statistik_pending_total'] = number_format($row->statistik_pending_total, 0, ',', '.');
                $data['statistik_pending_jumlah'] = number_format($row->statistik_pending_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_pending_total'] = '0';
            $data['statistik_pending_jumlah'] = '0';
        }

        //GAGAL
        if (strlen($txt_cari) > 0) {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_gagal_total,
                                        count(trx_grab_kode) as statistik_gagal_jumlah from tbl_trx_grab
                                        where
                                        trx_grab_kode LIKE '%$txt_cari%'and 
                                        trx_grab_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_grab_nama LIKE '%$txt_cari%' and 
                                        trx_grab_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_grab_status LIKE '%$txt_cari%' and 
                                        trx_grab_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_grab_nomor LIKE '%$txt_cari%'and 
                                        trx_grab_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')");
        } else {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_gagal_total,
                                        count(trx_grab_kode) as statistik_gagal_jumlah from tbl_trx_grab
                                        where trx_grab_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_grab_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')");
        }

        if ($gagal->num_rows() > 0) {
            foreach ($gagal->result() as $row) {
                $data['statistik_gagal_total'] = number_format($row->statistik_gagal_total, 0, ',', '.');
                $data['statistik_gagal_jumlah'] = number_format($row->statistik_gagal_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_gagal_total'] = '0';
            $data['statistik_gagal_jumlah'] = '0';
        }

        //SEMUA
        if (strlen($txt_cari) > 0) {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_semua_total,
                                        count(trx_grab_kode) as statistik_semua_jumlah from tbl_trx_grab
                                        where
                                        trx_grab_kode LIKE '%$txt_cari%' 
                                        OR
                                        trx_grab_nama LIKE '%$txt_cari%'
                                        OR
                                        trx_grab_status LIKE '%$txt_cari%' 
                                        OR
                                        trx_grab_nomor LIKE '%$txt_cari%'");
        } else {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_grab_admin + trx_grab_harga) as statistik_semua_total,
                                        count(trx_grab_kode) as statistik_semua_jumlah from tbl_trx_grab
                                        where trx_grab_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");
        }

        if ($semua->num_rows() > 0) {
            foreach ($semua->result() as $row) {
                $data['statistik_semua_total'] = number_format($row->statistik_semua_total, 0, ',', '.');
                $data['statistik_semua_jumlah'] = number_format($row->statistik_semua_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_semua_total'] = '0';
            $data['statistik_semua_jumlah'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_transaksi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_grab');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->transaksi_grab->get_datatables_cari($txt_cari);
        } else {
            $list = $this->transaksi_grab->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            //STATUS
            if ($field->trx_grab_rc == '00') {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                             <a class='dropdown-item' onclick=aksi_gagal()>SET KE GAGAL</a>
                            <a class='dropdown-item' onclick=aksi_pending('" . $field->trx_grab_kode . "')>SET KE PENDING</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>$field->trx_grab_status</div>";
            } else  if ($field->trx_grab_rc == '03') {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_sukses()>SET KE SUKSES</a>
                            <a class='dropdown-item' onclick=aksi_gagal()>SET KE GAGAL</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-warning'>$field->trx_grab_status</div>";
            } else {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                             <a class='dropdown-item' onclick=aksi_sukses()>SET KE SUKSES</a>
                            <a class='dropdown-item' onclick=aksi_pending('" . $field->trx_grab_kode . "')>SET KE PENDING</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>$field->trx_grab_status</div>";
            }


            $row[] = $no;
            $row[] = $aksi;
            $row[] = $status;
            $row[] = $field->trx_grab_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->trx_grab_kode;
            $row[] = $field->trx_grab_nomor;
            $row[] = $field->trx_grab_nama;
            $row[] = number_format($field->trx_grab_admin, 0, ',', '.');
            $row[] = number_format($field->trx_grab_harga, 0, ',', '.');
            $row[] = number_format($field->trx_grab_harga + $field->trx_grab_admin, 0, ',', '.');
            $row[] = $field->trx_grab_poin;
            $row[] = $field->trx_grab_sn;
            $row[] = $field->trx_grab_keterangan;
            $row[] = $field->trx_grab_notasi;
            $row[] = date("d M Y H:i:s", strtotime($field->trx_grab_tanggal));
            $row[] = $field->trx_grab_rc;
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transaksi_grab->count_all_cari($txt_cari),
                "recordsFiltered" => $this->transaksi_grab->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transaksi_grab->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->transaksi_grab->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }

    function aksi_notifikasi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_grab');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_inbox_kode =  "INBOX-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $mst_inbox_tanggal = date('Y-m-d H:i:s');
        $notifikasi_user_kode = $this->input->post("notifikasi_user_kode");
        $notifikasi_judul = $this->input->post("notifikasi_judul");
        $notifikasi_isi = $this->input->post("notifikasi_isi");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$notifikasi_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //INSERT KE tbl_mst_inbox
            $db_arifahpulsa_api->query("insert into tbl_mst_inbox (
                        mst_inbox_kode, 
                        mst_inbox_user_kode, 
                        mst_inbox_jenis, 
                        mst_inbox_judul, 
                        mst_inbox_isi,
                        mst_inbox_tanggal,
                        mst_inbox_jangka_waktu,
                        mst_inbox_status) values (
                        '$mst_inbox_kode', 
                        '$notifikasi_user_kode', 
                        'Teks',
                        '" . str_replace("'", "\'", $notifikasi_judul) . "',
                        '" . str_replace("'", "\'", $notifikasi_isi) . "',
                        '$mst_inbox_tanggal',
                        '1',
                        '0')");

            //KIRIM NOTIFIKASI
            $title = $notifikasi_judul;
            $body =  strip_tags($notifikasi_isi);
            firebase_notification($title, $body, $mst_user_firebase);

            $data['notifikasi_status'] = '0';
            echo json_encode($data);
        } else {
            $data['notifikasi_status'] = '1';
            echo json_encode($data);
        }
    }

    function aksi_pending($trx_grab_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_grab');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);
        $grab = $db_arifahpulsa_api->query("SELECT * FROM tbl_trx_grab WHERE trx_grab_kode='$trx_grab_kode'");
        if ($grab->num_rows() > 0) {
            foreach ($grab->result() as $row) {
                $trx_grab_user_kode = $row->trx_grab_user_kode;
                $trx_grab_nomor = $row->trx_grab_nomor;
                $trx_grab_nama = $row->trx_grab_nama;
                $trx_grab_admin = $row->trx_grab_admin;
                $trx_grab_total = $row->trx_grab_harga + $row->trx_grab_admin;
                $trx_grab_poin = $row->trx_grab_poin;
                $trx_grab_tanggal = $row->trx_grab_tanggal;
                $trx_grab_rc = $row->trx_grab_rc;
            }

            //JIKA TRANSAKSI SUKSES
            if ($trx_grab_rc == '00') {
                //UPDATE tbl_trx_grab
                $db_arifahpulsa_api->query("UPDATE tbl_trx_grab set 
                        trx_grab_rc='03',
                        trx_grab_status='Penanganan',
                        trx_grab_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_grab_sn='-'
                        where
                        trx_grab_kode='$trx_grab_kode' and
                        trx_grab_user_kode='$trx_grab_user_kode'");

                //UPDATE STATUS tbl_trx_transaksi
                $db_arifahpulsa_api->query("UPDATE tbl_trx_transaksi set 
                        trx_transaksi_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_transaksi_rc='03', 
                        trx_transaksi_status='Penanganan'
                        where
                        trx_transaksi_kode='$trx_grab_kode' and
                        trx_transaksi_user_kode='$trx_grab_user_kode'");


                //HAPUS tbl_trx_pendapatan
                $db_arifahpulsa_api->query("DELETE from tbl_trx_pendapatan where trx_pendapatan_kode='$trx_grab_kode' and trx_pendapatan_user_kode='$trx_grab_user_kode'");

                //HAPUS tbl_trx_poin
                $db_arifahpulsa_api->query("DELETE from tbl_trx_poin where trx_poin_kode='$trx_grab_kode' and trx_poin_user_kode='$trx_grab_user_kode'");

                //UPDATE tbl_mst_poin
                $db_arifahpulsa_api->query("UPDATE tbl_mst_poin set 
                        mst_poin_jumlah=mst_poin_jumlah - '$trx_grab_poin'
                        where
                        mst_poin_user_kode='$trx_grab_user_kode'");

                //PANGGIL USER
                $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$trx_grab_user_kode'");
                if ($user->num_rows() > 0) {
                    foreach ($user->result() as $row) {
                        $mst_user_firebase = $row->mst_user_firebase;
                    }

                    //KIRIM NOTIFIKASI
                    $title = "Penanganan Transaksi";
                    $body =  "Pengisian grab ke nomor " . $trx_grab_nomor . " - " . $trx_grab_nama . " dalam proses penanganan oleh tim Arifah Pulsa karena transaksi yang tidak valid. Mohon dicek status transaksi secara berkala.";
                    firebase_notification($title, $body, $mst_user_firebase);
                }

                $data['transaksi_status'] = '0';
                echo json_encode($data);
            } else  if (
                $trx_grab_rc == '02' ||
                $trx_grab_rc == '50' ||
                $trx_grab_rc == '51' ||
                $trx_grab_rc == '52' ||
                $trx_grab_rc == '53' ||
                $trx_grab_rc == '54' ||
                $trx_grab_rc == '55' ||
                $trx_grab_rc == '56' ||
                $trx_grab_rc == '57' ||
                $trx_grab_rc == '58' ||
                $trx_grab_rc == '59' ||
                $trx_grab_rc == '62' ||
                $trx_grab_rc == '63' ||
                $trx_grab_rc == '64'
            ) {
                //JIKA TRANSAKSI GAGAL

                //UPDATE tbl_trx_grab
                $db_arifahpulsa_api->query("UPDATE tbl_trx_grab set 
                        trx_grab_rc='03',
                        trx_grab_status='Penanganan',
                        trx_grab_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_grab_sn='-'
                        where
                        trx_grab_kode='$trx_grab_kode' and
                        trx_grab_user_kode='$trx_grab_user_kode'");

                //UPDATE STATUS tbl_trx_transaksi
                $db_arifahpulsa_api->query("UPDATE tbl_trx_transaksi set 
                        trx_transaksi_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_transaksi_rc='03', 
                        trx_transaksi_status='Penanganan'
                        where
                        trx_transaksi_kode='$trx_grab_kode' and
                        trx_transaksi_user_kode='$trx_grab_user_kode'");

                //UPDATE tbl_mst_saldo
                $db_arifahpulsa_api->query("UPDATE tbl_mst_saldo set 
                        mst_saldo_jumlah=mst_saldo_jumlah - '$trx_grab_total'
                        where
                        mst_saldo_user_kode='$trx_grab_user_kode'");

                //PANGGIL USER
                $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$trx_grab_user_kode'");
                if ($user->num_rows() > 0) {
                    foreach ($user->result() as $row) {
                        $mst_user_firebase = $row->mst_user_firebase;
                    }

                    //KIRIM NOTIFIKASI
                    $title = "Penanganan Transaksi";
                    $body =  "Pengisian grab ke nomor " . $trx_grab_nomor . " - " . $trx_grab_nama . " dalam proses penanganan oleh tim Arifah Pulsa karena transaksi yang tidak valid. Mohon dicek status transaksi secara berkala.";
                    firebase_notification($title, $body, $mst_user_firebase);
                }

                $data['transaksi_status'] = '0';
                echo json_encode($data);
            } else {
                $data['transaksi_status'] = '1';
                echo json_encode($data);
            }
        }
    }
}
