<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Transaksi_mtix extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_transaksi_mtix', 'transaksi_mtix');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_mtix');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Transaksi M-TIX';

        $this->template->load('includes/header', 'transaksi/view_transaksi_mtix', $data);
    }


    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_mtix');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        //SUKSES
        if (strlen($txt_cari) > 0) {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_sukses_total,
                                        count(trx_mtix_kode) as statistik_sukses_jumlah from tbl_trx_mtix
                                        where
                                        trx_mtix_kode LIKE '%$txt_cari%'and 
                                        trx_mtix_rc='00'
                                        OR
                                        trx_mtix_nama LIKE '%$txt_cari%' and 
                                        trx_mtix_rc='00'
                                        OR
                                        trx_mtix_status LIKE '%$txt_cari%' and 
                                        trx_mtix_rc='00'
                                        OR
                                        trx_mtix_nomor LIKE '%$txt_cari%'and 
                                        trx_mtix_rc='00'");
        } else {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_sukses_total,
                                        count(trx_mtix_kode) as statistik_sukses_jumlah from tbl_trx_mtix
                                        where trx_mtix_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_mtix_rc='00'");
        }

        if ($sukses->num_rows() > 0) {
            foreach ($sukses->result() as $row) {
                $data['statistik_sukses_total'] = number_format($row->statistik_sukses_total, 0, ',', '.');
                $data['statistik_sukses_jumlah'] = number_format($row->statistik_sukses_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_sukses_total'] = '0';
            $data['statistik_sukses_jumlah'] = '0';
        }

        //PENDING
        if (strlen($txt_cari) > 0) {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_pending_total,
                                        count(trx_mtix_kode) as statistik_pending_jumlah from tbl_trx_mtix
                                        where
                                        trx_mtix_kode LIKE '%$txt_cari%'and 
                                        trx_mtix_rc='03'
                                        OR
                                        trx_mtix_nama LIKE '%$txt_cari%' and 
                                        trx_mtix_rc='03'
                                        OR
                                        trx_mtix_status LIKE '%$txt_cari%' and 
                                        trx_mtix_rc='03'
                                        OR
                                        trx_mtix_nomor LIKE '%$txt_cari%'and 
                                        trx_mtix_rc='03'");
        } else {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_pending_total,
                                        count(trx_mtix_kode) as statistik_pending_jumlah from tbl_trx_mtix
                                        where trx_mtix_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_mtix_rc='03'");
        }

        if ($pending->num_rows() > 0) {
            foreach ($pending->result() as $row) {
                $data['statistik_pending_total'] = number_format($row->statistik_pending_total, 0, ',', '.');
                $data['statistik_pending_jumlah'] = number_format($row->statistik_pending_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_pending_total'] = '0';
            $data['statistik_pending_jumlah'] = '0';
        }

        //GAGAL
        if (strlen($txt_cari) > 0) {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_gagal_total,
                                        count(trx_mtix_kode) as statistik_gagal_jumlah from tbl_trx_mtix
                                        where
                                        trx_mtix_kode LIKE '%$txt_cari%'and 
                                        trx_mtix_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_mtix_nama LIKE '%$txt_cari%' and 
                                        trx_mtix_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_mtix_status LIKE '%$txt_cari%' and 
                                        trx_mtix_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_mtix_nomor LIKE '%$txt_cari%'and 
                                        trx_mtix_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')");
        } else {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_gagal_total,
                                        count(trx_mtix_kode) as statistik_gagal_jumlah from tbl_trx_mtix
                                        where trx_mtix_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_mtix_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')");
        }

        if ($gagal->num_rows() > 0) {
            foreach ($gagal->result() as $row) {
                $data['statistik_gagal_total'] = number_format($row->statistik_gagal_total, 0, ',', '.');
                $data['statistik_gagal_jumlah'] = number_format($row->statistik_gagal_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_gagal_total'] = '0';
            $data['statistik_gagal_jumlah'] = '0';
        }

        //SEMUA
        if (strlen($txt_cari) > 0) {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_semua_total,
                                        count(trx_mtix_kode) as statistik_semua_jumlah from tbl_trx_mtix
                                        where
                                        trx_mtix_kode LIKE '%$txt_cari%' 
                                        OR
                                        trx_mtix_nama LIKE '%$txt_cari%'
                                        OR
                                        trx_mtix_status LIKE '%$txt_cari%' 
                                        OR
                                        trx_mtix_nomor LIKE '%$txt_cari%'");
        } else {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_mtix_admin + trx_mtix_harga) as statistik_semua_total,
                                        count(trx_mtix_kode) as statistik_semua_jumlah from tbl_trx_mtix
                                        where trx_mtix_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");
        }

        if ($semua->num_rows() > 0) {
            foreach ($semua->result() as $row) {
                $data['statistik_semua_total'] = number_format($row->statistik_semua_total, 0, ',', '.');
                $data['statistik_semua_jumlah'] = number_format($row->statistik_semua_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_semua_total'] = '0';
            $data['statistik_semua_jumlah'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_transaksi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_mtix');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->transaksi_mtix->get_datatables_cari($txt_cari);
        } else {
            $list = $this->transaksi_mtix->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            //STATUS
            if ($field->trx_mtix_rc == '00') {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                             <a class='dropdown-item' onclick=aksi_gagal()>SET KE GAGAL</a>
                            <a class='dropdown-item' onclick=aksi_pending('" . $field->trx_mtix_kode . "')>SET KE PENDING</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>$field->trx_mtix_status</div>";
            } else  if ($field->trx_mtix_rc == '03') {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_sukses()>SET KE SUKSES</a>
                            <a class='dropdown-item' onclick=aksi_gagal()>SET KE GAGAL</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-warning'>$field->trx_mtix_status</div>";
            } else {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                             <a class='dropdown-item' onclick=aksi_sukses()>SET KE SUKSES</a>
                            <a class='dropdown-item' onclick=aksi_pending('" . $field->trx_mtix_kode . "')>SET KE PENDING</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>$field->trx_mtix_status</div>";
            }


            $row[] = $no;
            $row[] = $aksi;
            $row[] = $status;
            $row[] = $field->trx_mtix_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->trx_mtix_kode;
            $row[] = $field->trx_mtix_nomor;
            $row[] = $field->trx_mtix_nama;
            $row[] = number_format($field->trx_mtix_admin, 0, ',', '.');
            $row[] = number_format($field->trx_mtix_harga, 0, ',', '.');
            $row[] = number_format($field->trx_mtix_harga + $field->trx_mtix_admin, 0, ',', '.');
            $row[] = $field->trx_mtix_poin;
            $row[] = $field->trx_mtix_sn;
            $row[] = $field->trx_mtix_keterangan;
            $row[] = $field->trx_mtix_notasi;
            $row[] = date("d M Y H:i:s", strtotime($field->trx_mtix_tanggal));
            $row[] = $field->trx_mtix_rc;
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transaksi_mtix->count_all_cari($txt_cari),
                "recordsFiltered" => $this->transaksi_mtix->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transaksi_mtix->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->transaksi_mtix->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }

    function aksi_notifikasi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_mtix');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_inbox_kode =  "INBOX-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $mst_inbox_tanggal = date('Y-m-d H:i:s');
        $notifikasi_user_kode = $this->input->post("notifikasi_user_kode");
        $notifikasi_judul = $this->input->post("notifikasi_judul");
        $notifikasi_isi = $this->input->post("notifikasi_isi");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$notifikasi_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //INSERT KE tbl_mst_inbox
            $db_arifahpulsa_api->query("insert into tbl_mst_inbox (
                        mst_inbox_kode, 
                        mst_inbox_user_kode, 
                        mst_inbox_jenis, 
                        mst_inbox_judul, 
                        mst_inbox_isi,
                        mst_inbox_tanggal,
                        mst_inbox_jangka_waktu,
                        mst_inbox_status) values (
                        '$mst_inbox_kode', 
                        '$notifikasi_user_kode', 
                        'Teks',
                        '" . str_replace("'", "\'", $notifikasi_judul) . "',
                        '" . str_replace("'", "\'", $notifikasi_isi) . "',
                        '$mst_inbox_tanggal',
                        '1',
                        '0')");

            //KIRIM NOTIFIKASI
            $title = $notifikasi_judul;
            $body =  strip_tags($notifikasi_isi);
            firebase_notification($title, $body, $mst_user_firebase);

            $data['notifikasi_status'] = '0';
            echo json_encode($data);
        } else {
            $data['notifikasi_status'] = '1';
            echo json_encode($data);
        }
    }

    function aksi_pending($trx_mtix_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_mtix');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);
        $mtix = $db_arifahpulsa_api->query("SELECT * FROM tbl_trx_mtix WHERE trx_mtix_kode='$trx_mtix_kode'");
        if ($mtix->num_rows() > 0) {
            foreach ($mtix->result() as $row) {
                $trx_mtix_user_kode = $row->trx_mtix_user_kode;
                $trx_mtix_nomor = $row->trx_mtix_nomor;
                $trx_mtix_nama = $row->trx_mtix_nama;
                $trx_mtix_admin = $row->trx_mtix_admin;
                $trx_mtix_total = $row->trx_mtix_harga + $row->trx_mtix_admin;
                $trx_mtix_poin = $row->trx_mtix_poin;
                $trx_mtix_tanggal = $row->trx_mtix_tanggal;
                $trx_mtix_rc = $row->trx_mtix_rc;
            }

            //JIKA TRANSAKSI SUKSES
            if ($trx_mtix_rc == '00') {
                //UPDATE tbl_trx_mtix
                $db_arifahpulsa_api->query("UPDATE tbl_trx_mtix set 
                        trx_mtix_rc='03',
                        trx_mtix_status='Penanganan',
                        trx_mtix_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_mtix_sn='-'
                        where
                        trx_mtix_kode='$trx_mtix_kode' and
                        trx_mtix_user_kode='$trx_mtix_user_kode'");

                //UPDATE STATUS tbl_trx_transaksi
                $db_arifahpulsa_api->query("UPDATE tbl_trx_transaksi set 
                        trx_transaksi_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_transaksi_rc='03', 
                        trx_transaksi_status='Penanganan'
                        where
                        trx_transaksi_kode='$trx_mtix_kode' and
                        trx_transaksi_user_kode='$trx_mtix_user_kode'");


                //HAPUS tbl_trx_pendapatan
                $db_arifahpulsa_api->query("DELETE from tbl_trx_pendapatan where trx_pendapatan_kode='$trx_mtix_kode' and trx_pendapatan_user_kode='$trx_mtix_user_kode'");

                //HAPUS tbl_trx_poin
                $db_arifahpulsa_api->query("DELETE from tbl_trx_poin where trx_poin_kode='$trx_mtix_kode' and trx_poin_user_kode='$trx_mtix_user_kode'");

                //UPDATE tbl_mst_poin
                $db_arifahpulsa_api->query("UPDATE tbl_mst_poin set 
                        mst_poin_jumlah=mst_poin_jumlah - '$trx_mtix_poin'
                        where
                        mst_poin_user_kode='$trx_mtix_user_kode'");

                //PANGGIL USER
                $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$trx_mtix_user_kode'");
                if ($user->num_rows() > 0) {
                    foreach ($user->result() as $row) {
                        $mst_user_firebase = $row->mst_user_firebase;
                    }

                    //KIRIM NOTIFIKASI
                    $title = "Penanganan Transaksi";
                    $body =  "Pengisian mtix ke nomor " . $trx_mtix_nomor . " - " . $trx_mtix_nama . " dalam proses penanganan oleh tim Arifah Pulsa karena transaksi yang tidak valid. Mohon dicek status transaksi secara berkala.";
                    firebase_notification($title, $body, $mst_user_firebase);
                }

                $data['transaksi_status'] = '0';
                echo json_encode($data);
            } else  if (
                $trx_mtix_rc == '02' ||
                $trx_mtix_rc == '50' ||
                $trx_mtix_rc == '51' ||
                $trx_mtix_rc == '52' ||
                $trx_mtix_rc == '53' ||
                $trx_mtix_rc == '54' ||
                $trx_mtix_rc == '55' ||
                $trx_mtix_rc == '56' ||
                $trx_mtix_rc == '57' ||
                $trx_mtix_rc == '58' ||
                $trx_mtix_rc == '59' ||
                $trx_mtix_rc == '62' ||
                $trx_mtix_rc == '63' ||
                $trx_mtix_rc == '64'
            ) {
                //JIKA TRANSAKSI GAGAL

                //UPDATE tbl_trx_mtix
                $db_arifahpulsa_api->query("UPDATE tbl_trx_mtix set 
                        trx_mtix_rc='03',
                        trx_mtix_status='Penanganan',
                        trx_mtix_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_mtix_sn='-'
                        where
                        trx_mtix_kode='$trx_mtix_kode' and
                        trx_mtix_user_kode='$trx_mtix_user_kode'");

                //UPDATE STATUS tbl_trx_transaksi
                $db_arifahpulsa_api->query("UPDATE tbl_trx_transaksi set 
                        trx_transaksi_notasi='Transaksi mengalami kendala, status transaksi saat ini dalam proses penanganan oleh tim Arifah Pulsa. Mohon dicek transaksi ini secara berkala',
                        trx_transaksi_rc='03', 
                        trx_transaksi_status='Penanganan'
                        where
                        trx_transaksi_kode='$trx_mtix_kode' and
                        trx_transaksi_user_kode='$trx_mtix_user_kode'");

                //UPDATE tbl_mst_saldo
                $db_arifahpulsa_api->query("UPDATE tbl_mst_saldo set 
                        mst_saldo_jumlah=mst_saldo_jumlah - '$trx_mtix_total'
                        where
                        mst_saldo_user_kode='$trx_mtix_user_kode'");

                //PANGGIL USER
                $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$trx_mtix_user_kode'");
                if ($user->num_rows() > 0) {
                    foreach ($user->result() as $row) {
                        $mst_user_firebase = $row->mst_user_firebase;
                    }

                    //KIRIM NOTIFIKASI
                    $title = "Penanganan Transaksi";
                    $body =  "Pengisian mtix ke nomor " . $trx_mtix_nomor . " - " . $trx_mtix_nama . " dalam proses penanganan oleh tim Arifah Pulsa karena transaksi yang tidak valid. Mohon dicek status transaksi secara berkala.";
                    firebase_notification($title, $body, $mst_user_firebase);
                }

                $data['transaksi_status'] = '0';
                echo json_encode($data);
            } else {
                $data['transaksi_status'] = '1';
                echo json_encode($data);
            }
        }
    }
}
