  <div class="container-fluid">
      <div class="row">
          <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box">
                  <span class="info-box-icon bg-info elevation-1"><i class="fas fa-money-bill"></i></span>

                  <div class="info-box-content">
                      <span class="info-box-text">Pendapatan</span>
                      <span class="info-box-number">
                          <small>Rp. </small>
                          <label id="transaksi_pendapatan">Loading...</label>

                      </span>
                  </div>
                  <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                  <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-bullseye"></i></span>

                  <div class="info-box-content">
                      <span class="info-box-text">Saldo User</span>
                      <span class="info-box-number">
                          <small>Rp. </small>
                          <label id="transaksi_saldo">Loading...</label>
                      </span>
                  </div>
                  <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
          </div>
          <!-- /.col -->

          <!-- fix for small devices only -->
          <div class="clearfix hidden-md-up"></div>

          <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                  <span class="info-box-icon bg-success elevation-1"><i class="fas fa-shopping-cart"></i></span>

                  <div class="info-box-content">
                      <span class="info-box-text">Total Transaksi</span>
                      <span class="info-box-number">
                          <small>Rp. </small>
                          <label id="transaksi_jumlah">Loading...</label>
                      </span>
                  </div>
                  <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                  <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>

                  <div class="info-box-content">
                      <span class="info-box-text">Total User</span>
                      <span class="info-box-number">
                          <small>User. </small>
                          <label id="transaksi_user">Loading...</label>
                      </span>

                  </div>
                  <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
          </div>
          <!-- /.col -->
      </div>

      <div class="container-fluid">
          <div class="row">
              <div style="margin-bottom: 10px;" class="col-md-3">
                  <input type="text" class="form-control col-md-12" id="transaksi_tanggal" placeholder="Pilih tanggal">
              </div>

              <div style="margin-bottom: 10px;" class="col-md-7">
                  <input type="text" class="form-control col-md-12" id="txt_cari" placeholder="Cari kode transaksi, kategori transaksi, nama produk, status transaksi dan nomor tujuan">

              </div>

              <div style="margin-bottom: 10px;" class="col-md-2">
                  <button type="button" id="btn_cari" class="btn btn-primary col-md-12">Cari</button>
              </div>
          </div>

          <div class="row">
              <div class="col-md-3 col-sm-6 col-12">
                  <div class="info-box bg-gradient-success">
                      <span class="info-box-icon"><i class="fas fa-chart-line"></i></span>
                      <div class="info-box-content">
                          <span class="info-box-text">Transaksi Sukses</span>
                          <span id="statistik_sukses_total" class="info-box-number">Loading...</span>

                          <div class="progress">
                              <div class="progress-bar" style="width: 100%"></div>
                          </div>
                          <span id="statistik_sukses_jumlah" class="progress-description">
                              Loading...
                          </span>
                      </div>
                  </div>
              </div>

              <div class="col-md-3 col-sm-6 col-12">
                  <div class="info-box bg-gradient-warning">
                      <span class="info-box-icon"><i class="far fa-clock"></i></span>
                      <div class="info-box-content">
                          <span class="info-box-text">Transaksi Pending</span>
                          <span id="statistik_pending_total" class="info-box-number">Loading...</span>

                          <div class="progress">
                              <div class="progress-bar" style="width: 100%"></div>
                          </div>
                          <span id="statistik_pending_jumlah" class="progress-description">
                              Loading...
                          </span>
                      </div>
                  </div>
              </div>

              <!-- fix for small devices only -->
              <div class="clearfix hidden-md-up"></div>

              <div class="col-md-3 col-sm-6 col-12">
                  <div class="info-box bg-gradient-danger">
                      <span class="info-box-icon"><i class="fas fa-poop"></i></span>
                      <div class="info-box-content">
                          <span class="info-box-text">Transaksi Gagal</span>
                          <span id="statistik_gagal_total" class="info-box-number">Loading...</span>

                          <div class="progress">
                              <div class="progress-bar" style="width: 100%"></div>
                          </div>
                          <span id="statistik_gagal_jumlah" class="progress-description">
                              Loading...
                          </span>
                      </div>
                  </div>
              </div>

              <div class="col-md-3 col-sm-6 col-12">
                  <div class="info-box bg-gradient-primary">
                      <span class="info-box-icon"><i class="	fas fa-money-bill"></i></span>
                      <div class="info-box-content">
                          <span class="info-box-text">Semua Transaksi</span>
                          <span id="statistik_semua_total" class="info-box-number">Loading...</span>

                          <div class="progress">
                              <div class="progress-bar" style="width: 100%"></div>
                          </div>
                          <span id="statistik_semua_jumlah" class="progress-description">
                              Loading...
                          </span>
                      </div>
                  </div>
              </div>
          </div>

          <div class="row">
              <div class="col-md-12">
                  <div class="card card-primary">
                      <div class="card-header">
                          <h3 class="card-title">TRANSAKSI</h3>
                      </div>
                      <div class="card-body">
                          <div class="table-responsive">
                              <table id='table_transaksi' class='table table-bordered table-striped' width='100%'>
                                  <thead>
                                      <tr>
                                          <th width='100px'>No</th>
                                          <th width='100px'>STATUS</th>
                                          <th width='150px'>KATEGORI</th>
                                          <th width='100px'>KODE USER</th>
                                          <th width='100px'>NAMA USER</th>
                                          <th width='190px'>KODE TRANSAKSI</th>
                                          <th width='100px'>NOMOR</th>
                                          <th width='250px'>NAMA</th>
                                          <th width='100px'>JUMLAH</th>
                                          <th width='100px'>KETERANGAN</th>
                                          <th width='100px'>NOTASI</th>
                                          <th width='100px'>TANGGAL</th>
                                          <th width='100px'>RC</th>
                                      </tr>
                                  </thead>
                              </table>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>

      <div class="row">

          <div class="col-12">
              <div class="card card-primary card-outline">
                  <div class="card-header">
                      <h3 id="grafik_judul" class="card-title">
                          <i class="far fa-chart-bar"></i>
                          Grafik transaksi
                      </h3>

                      <div class="card-tools">
                          <h3 id="grafik_jumlah" class="btn btn-danger"></h3>
                          <h3 id="grafik_bulan" class="btn btn-success"></h3>
                          <h3 onclick="aksi_grafik();" class="btn btn-success">Refresh</h3>
                      </div>
                  </div>

                  <div id="grafik_loading" class="overlay">
                      <i class="fas fa-3x fa-sync-alt fa-spin"></i>
                  </div>

                  <div class="card-body">
                      <div id="grafik_tabel" style="height: 300px; "></div>
                  </div>

                  <!-- /.card-body-->
              </div>

          </div>

          <div class="col-md-6">
              <div class="card card-primary">
                  <div class="card-header">
                      <h5 class="card-title btn btn-primary">Produk prabayar yang sedang gangguan</h5>

                      <div class="card-tools">
                          <h3 onclick="aksi_produk_prabayar();" class="btn btn-success ">Update Produk</h3>
                      </div>
                  </div>

                  <div class="card-body">
                      <center>
                          <div id="produk_prabayar_loading" class="overlay">
                              <i class="fas fa-3x fa-sync-alt fa-spin"></i>
                          </div>
                      </center>
                      <div class="table-responsive">
                          <div id="produk_prabayar_tabel"></div>
                      </div>
                  </div>
              </div>
          </div>

          <div class="col-md-6">
              <div class="card card-success">
                  <div class="card-header">
                      <h5 class="card-title btn btn-success">Produk pascabayar yang sedang gangguan</h5>

                      <div class="card-tools">
                          <h3 onclick="aksi_produk_pascabayar();" class="btn btn-primary">Update Produk</h3>
                      </div>
                  </div>
                  <div class="card-body">
                      <center>
                          <div id="produk_pascabayar_loading" class="overlay">
                              <i class="fas fa-3x fa-sync-alt fa-spin"></i>
                          </div>
                      </center>
                      <div class="table-responsive">
                          <div id="produk_pascabayar_tabel"></div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>

  <script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>

  <script type='text/javascript'>
      $(function() {
          $("#table").DataTable({
              "responsive": true,
              "lengthChange": false,
              "autoWidth": true,
              "ordering": true,
              "info": true,
              "paging": true,
              "buttons": ["copy", "print"]
          }).buttons().container().appendTo('#table_wrapper .col-md-6:eq(0)');
      });

      var today = new Date();
      var dd = String(today.getDate()).padStart(2, '0');
      var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
      var yyyy = today.getFullYear();
      today = yyyy + '/' + mm + '/' + dd;

      var startDate = today;
      var endDate = today;

      $(document).ready(function() {

          var txt_cari = $("#txt_cari").val();

          //PANGGIL DATA
          aksi_panel();
          aksi_transaksi(startDate, endDate);
          aksi_statistik(startDate, endDate);
          aksi_grafik();
          aksi_produk_prabayar();
          aksi_produk_pascabayar();


          //ENTER
          var input = document.getElementById("txt_cari");
          input.addEventListener("keypress", function(event) {
              if (event.key === "Enter") {
                  event.preventDefault();
                  document.getElementById("btn_cari").click();
              }
          });

          //CARI
          $('#btn_cari').click(function() {
              var txt_cari = $("#txt_cari").val();
              if (txt_cari.length >= 2) {
                  //CLEAR DATA
                  var table = $('#table').DataTable();
                  table.clear().draw();

                  aksi_transaksi(startDate, endDate);
                  aksi_statistik(startDate, endDate);
              } else {
                  toastr.info('Mohon lengkapi kata kunci pencarian anda!')
              }

          });

          //TANGGAL
          $('#transaksi_tanggal').daterangepicker({
                  startDate: moment(),
                  endDate: moment(),
                  minDate: '01/01/2020',
                  maxDate: '12/31/2050',
                  dateLimit: {
                      days: 160
                  },
                  showDropdowns: true,
                  showWeekNumbers: true,
                  timePicker: false,
                  timePickerIncrement: 1,
                  timePicker12Hour: true,
                  ranges: {
                      'Hari Ini': [moment(), moment()],
                      'Kemarin': [moment().subtract('days', 1), moment().subtract('days', 1)],
                      '7 Hari Terkahir': [moment().subtract('days', 6), moment()],
                      '30 Hari Terakhir': [moment().subtract('days', 29), moment()],
                      'Bulan Ini': [moment().startOf('month'), moment().endOf('month')],
                      'Bulan Lalu': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')],
                      'Tahun Ini': [moment().startOf('year'), moment().endOf('year')],
                      'Tahun Lalu': [moment().subtract('year', 1).startOf('year'), moment().subtract('year', 1).endOf('year')]
                  },
                  opens: 'left',
                  buttonClasses: ['btn btn-default'],
                  applyClass: 'btn-small btn-primary',
                  cancelClass: 'btn-small',
                  format: 'DD/MM/YYYY',
                  separator: ' to ',
                  locale: {
                      applyLabel: 'Oke',
                      fromLabel: 'Dari',
                      toLabel: 'Ke',
                      customRangeLabel: 'Custom Tanggal',
                      daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
                      monthNames: ['Januari', 'Februari', 'Maret', 'April', 'Mai', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
                      firstDay: 1
                  }
              },
              function(start, end) {
                  console.log("Callback has been called!");
                  $('#transaksi_tanggal span').html(start.format('YYYY/MM/DD') + ' - ' + end.format('YYYY/MM/DD'));
                  startDate = start.format('YYYY/MM/DD');
                  endDate = end.format('YYYY/MM/DD');

                  //CLEAR DATA
                  var table = $('#table').DataTable();
                  table.clear().draw();

                  //CLEAR CARI
                  $('#txt_cari').val('');

                  aksi_transaksi(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
                  aksi_statistik(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
              }
          );
          //Set the initial state of the picker label
          $('#transaksi_tanggal span').html(moment().subtract('days', 29).format('YYYY/MM/DD') + ' - ' + moment().format('YYYY/MM/DD'));

          $('#transaksi_tanggal').on('apply.daterangepicker', function(ev, picker) {
              $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
          });

          //SELECT2
          $('.select2').select2()
          $('.select2bs4').select2({
              theme: 'bootstrap4'
          })

      });

      function aksi_panel() {
          $.ajax({
              type: 'POST',
              url: '<?php echo base_url() ?>dashboard/aksi_panel/',
              success: function(data) {
                  var obj = JSON.parse(data);
                  var transaksi_pendapatan = obj.transaksi_pendapatan;
                  var transaksi_saldo = obj.transaksi_saldo;
                  var transaksi_jumlah = obj.transaksi_jumlah;
                  var transaksi_user = obj.transaksi_user;
                  console.log(obj);

                  document.getElementById("transaksi_pendapatan").innerHTML = obj.transaksi_pendapatan;
                  document.getElementById("transaksi_saldo").innerHTML = obj.transaksi_saldo;
                  document.getElementById("transaksi_jumlah").innerHTML = obj.transaksi_jumlah;
                  document.getElementById("transaksi_user").innerHTML = obj.transaksi_user;
              }
          })
      }

      function aksi_transaksi(startDate, endDate) {
          var txt_cari = $("#txt_cari").val();
          $('#table_transaksi').DataTable({
              "destroy": true,
              "searching": true,
              "processing": true,
              "serverSide": true,
              'scrollX': true,
              'sScrollX': '100%',
              'sScrollY': '500',
              'ordering': false,
              "info": true,
              "paging": true,
              "order": [],
              "ajax": {
                  "url": "<?php echo site_url('/dashboard/aksi_transaksi') ?>",
                  "type": "POST",
                  data: {
                      startDate: startDate,
                      endDate: endDate,
                      txt_cari: txt_cari,
                  }
              },
              "dom": "<'row'<'col-sm-12 col-md-12'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-6'f>>" +
                  "<'row'<'.col-md-6:eq(0)'tr>>" +
                  "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
              "buttons": ["copy", "print"],

          });
      }

      function aksi_statistik(startDate, endDate) {
          var txt_cari = $("#txt_cari").val();
          document.getElementById("statistik_sukses_total").innerHTML = 'Loading...';
          document.getElementById("statistik_sukses_jumlah").innerHTML = 'Loading...';
          document.getElementById("statistik_pending_total").innerHTML = 'Loading...';
          document.getElementById("statistik_pending_jumlah").innerHTML = 'Loading...';
          document.getElementById("statistik_gagal_total").innerHTML = 'Loading...';
          document.getElementById("statistik_gagal_jumlah").innerHTML = 'Loading...';
          document.getElementById("statistik_semua_total").innerHTML = 'Loading...';
          document.getElementById("statistik_semua_jumlah").innerHTML = 'Loading...';

          $.ajax({
              type: 'POST',
              url: '<?php echo base_url() ?>dashboard/aksi_statistik',
              data: {
                  startDate: startDate,
                  endDate: endDate,
                  txt_cari: txt_cari,
              },
              success: function(data) {
                  var obj = JSON.parse(data);
                  var statistik_sukses_total = obj.statistik_sukses_total;
                  var statistik_sukses_jumlah = obj.statistik_sukses_jumlah;
                  var statistik_pending_total = obj.statistik_pending_total;
                  var statistik_pending_jumlah = obj.statistik_pending_jumlah;
                  var statistik_gagal_total = obj.statistik_gagal_total;
                  var statistik_gagal_jumlah = obj.statistik_gagal_jumlah;
                  var statistik_semua_total = obj.statistik_semua_total;
                  var statistik_semua_jumlah = obj.statistik_semua_jumlah;


                  document.getElementById("statistik_sukses_total").innerHTML = obj.statistik_sukses_total;
                  document.getElementById("statistik_sukses_jumlah").innerHTML = obj.statistik_sukses_jumlah + ' transaksi';
                  document.getElementById("statistik_pending_total").innerHTML = obj.statistik_pending_total;
                  document.getElementById("statistik_pending_jumlah").innerHTML = obj.statistik_pending_jumlah + ' transaksi';
                  document.getElementById("statistik_gagal_total").innerHTML = obj.statistik_gagal_total;
                  document.getElementById("statistik_gagal_jumlah").innerHTML = obj.statistik_gagal_jumlah + ' transaksi';
                  document.getElementById("statistik_semua_total").innerHTML = obj.statistik_semua_total;
                  document.getElementById("statistik_semua_jumlah").innerHTML = obj.statistik_semua_jumlah + ' transaksi';
              }
          })
      }

      function aksi_grafik() {
          document.getElementById("grafik_loading").style.visibility = "visible";
          document.getElementById("grafik_jumlah").style.visibility = "hidden";
          document.getElementById("grafik_bulan").style.visibility = "hidden";
          document.getElementById("grafik_tabel").style.visibility = "hidden";

          $.ajax({
              type: 'POST',
              url: '<?php echo base_url() ?>dashboard/aksi_grafik',
              success: function(data) {
                  // RESPONSE
                  var obj = JSON.parse(data);
                  var transaksi_item = obj.transaksi_item;
                  var hari_item = obj.hari_item;
                  var bulan_item = obj.bulan_item;
                  var tahun_item = obj.tahun_item;
                  var jumlah_item = obj.tahun_item;
                  console.log(obj);

                  //SET VALUE
                  document.getElementById("grafik_tabel").style.visibility = "visible";
                  document.getElementById("grafik_jumlah").style.visibility = "visible";
                  document.getElementById("grafik_loading").style.visibility = "hidden";
                  document.getElementById("grafik_bulan").style.visibility = "visible";

                  document.getElementById("grafik_jumlah").innerHTML = obj.jumlah_item + ' transaksi';
                  document.getElementById("grafik_bulan").innerHTML = obj.bulan_item + ' ' + obj.tahun_item;

                  var bar_data = {
                      data: transaksi_item,
                      bars: {
                          show: true
                      }
                  }
                  $.plot('#grafik_tabel', [bar_data], {
                      grid: {
                          borderWidth: 1,
                          borderColor: '#f3f3f3',
                          tickColor: '#f3f3f3'
                      },
                      series: {
                          bars: {
                              show: true,
                              barWidth: 0.5,
                              align: 'center',
                          },
                      },
                      colors: ['#3c8dbc'],
                      xaxis: {
                          ticks: hari_item
                      }
                  })
              }
          })
      }

      function aksi_produk_prabayar() {
          document.getElementById("produk_prabayar_loading").style.display = "block";
          document.getElementById("produk_prabayar_tabel").style.display = "none";
          $.ajax({
              type: 'POST',
              url: '<?php echo base_url() ?>dashboard/aksi_produk_prabayar/',
              success: function(html) {
                  $("#produk_prabayar_tabel").html(html);
                  document.getElementById("produk_prabayar_loading").style.display = "none";
                  document.getElementById("produk_prabayar_tabel").style.display = "block";
              }
          })
      }

      function aksi_produk_pascabayar() {
          document.getElementById("produk_pascabayar_loading").style.display = "block";
          document.getElementById("produk_pascabayar_tabel").style.display = "none";
          $.ajax({
              type: 'POST',
              url: '<?php echo base_url() ?>dashboard/aksi_produk_pascabayar/',
              success: function(html) {
                  $("#produk_pascabayar_tabel").html(html);
                  document.getElementById("produk_pascabayar_loading").style.display = "none";
                  document.getElementById("produk_pascabayar_tabel").style.display = "block";
              }
          })
      }
  </script>