<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">KATEGORI PRODUK</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" onclick="aksi_data()"><i class="fas fa-sync-alt"></i></button>
                    </div>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_produk">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>
            <form enctype="multipart/form-data" id="submit">
                <div class="modal-header">
                    <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                    <button type="button" class="close" onclick="aksi_tutup_modal()" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Kode</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="ktg_produk_kode" name="ktg_produk_kode" placeholder="Kode kategori">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Nama</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="ktg_produk_nama" name="ktg_produk_nama" placeholder="Nama kategori">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Icon</label>
                                <div class="col-lg-9">
                                    <input type="file" class="form-control" id="ktg_produk_icon" name="ktg_produk_icon">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Urutan</label>
                                <div class="col-lg-9">
                                    <input type="number" class="form-control" id="ktg_produk_urutan" name="ktg_produk_urutan" placeholder="Urutan tampil">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Keterangan</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="ktg_produk_keterangan" name="ktg_produk_keterangan" placeholder="Keterangan">
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                    <button type="submit" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>

<script type='text/javascript'>
    var submit_status;
    $(document).ready(function() {
        aksi_data();
    });

    $('#submit').submit(function(e) {
        e.preventDefault();
        var ktg_produk_kode = $("#ktg_produk_kode").val();
        var ktg_produk_nama = $("#ktg_produk_nama").val();
        var ktg_produk_icon = $("#ktg_produk_icon").val();
        var ktg_produk_urutan = $("#ktg_produk_urutan").val();
        var ktg_produk_keterangan = $("#ktg_produk_keterangan").val();

        //EDIT
        if (submit_status == 'Edit') {
            if (ktg_produk_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (ktg_produk_nama.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (ktg_produk_urutan.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                $.ajax({
                    url: '<?php echo base_url() ?>kategori/kategori_produk/aksi_edit',
                    type: "POST",
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        toastr.success('Kategori berhasil di edit');

                        //SET VALUE
                        document.getElementById("ktg_produk_kode").value = '';
                        document.getElementById("ktg_produk_nama").value = '';
                        document.getElementById("ktg_produk_icon").value = '';
                        document.getElementById("ktg_produk_urutan").value = '';
                        document.getElementById("ktg_produk_keterangan").value = '';

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        //MODAL
                        $("#modal_produk").modal('hide');

                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Kategori gagal di edit');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

        //TAMBAH
        if (submit_status == 'Tambah') {
            if (ktg_produk_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (ktg_produk_nama.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (ktg_produk_icon.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (ktg_produk_urutan.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                $.ajax({
                    url: '<?php echo base_url() ?>kategori/kategori_produk/aksi_tambah',
                    type: "POST",
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var tambah_status = obj.tambah_status;

                        if (tambah_status == '0') {
                            toastr.success('Kategori berhasil di tambahkan');

                            //SET VALUE
                            document.getElementById("ktg_produk_kode").value = '';
                            document.getElementById("ktg_produk_nama").value = '';
                            document.getElementById("ktg_produk_icon").value = '';
                            document.getElementById("ktg_produk_urutan").value = '';
                            document.getElementById("ktg_produk_keterangan").value = '';

                            //LOADING
                            document.getElementById("modal_loading").style.visibility = "hidden";

                            aksi_data();
                        } else {
                            toastr.error('Kategori gagal di tambahkan karena kode kategori sudah pernah ditambahkan sebelumnya!');
                            document.getElementById("modal_loading").style.visibility = "hidden";
                        }

                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Kategori gagal di tambahkan');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>kategori/kategori_produk/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var ktg_produk_kode = $row.find("#tbl_ktg_produk_kode").text();;
        var ktg_produk_nama = $row.find("#tbl_ktg_produk_nama").text();
        var ktg_produk_urutan = $row.find("#tbl_ktg_produk_urutan").text();
        var ktg_produk_keterangan = $row.find("#tbl_ktg_produk_keterangan").text();

        //SET VALUE
        document.getElementById("ktg_produk_kode").value = ktg_produk_kode;
        document.getElementById("ktg_produk_nama").value = ktg_produk_nama;
        document.getElementById("ktg_produk_urutan").value = ktg_produk_urutan;
        document.getElementById("ktg_produk_keterangan").value = ktg_produk_keterangan;

        //DISABLE VALUE
        document.getElementById("ktg_produk_kode").readOnly = true;

        //SET STATUS
        submit_status = 'Edit';

        //SET TITLE
        $("#modal_title").html('EDIT KATEGORI PRODUK');

        //SHOW MODAL
        $('#modal_produk').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH KATEGORI PRODUK');

        //ENABLE VALUE
        document.getElementById("ktg_produk_kode").readOnly = false;

        //SET VALUE
        document.getElementById("ktg_produk_kode").value = '';
        document.getElementById("ktg_produk_nama").value = '';
        document.getElementById("ktg_produk_icon").value = '';
        document.getElementById("ktg_produk_urutan").value = '';
        document.getElementById("ktg_produk_keterangan").value = '';

        //SET STATUS
        submit_status = 'Tambah';

        //SHOW MODAL
        $('#modal_produk').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tidak_aktif(ktg_produk_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>kategori/kategori_produk/aksi_tidak_aktif/' + ktg_produk_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status kategori menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status kategori menjadi tidak aktif');
            }
        });
    }

    function aksi_aktif(ktg_produk_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>kategori/kategori_produk/aksi_aktif/' + ktg_produk_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status kategori menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status kategori menjadi tidak aktif');
            }
        });
    }

    function aksi_hapus(ktg_produk_kode) {
        Swal.fire({
            title: 'Yakin ingin menghapus kategori?',
            text: "Setelah menghapus, data tidak bisa dikembalikan lagi!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>kategori/kategori_produk/aksi_hapus/' + ktg_produk_kode,
                    type: "POST",
                    success: function() {
                        toastr.success('Berhasil menghapus kategori');
                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Gagal menghapus kategori');
                    }
                });
            }
        })


    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_produk").modal('hide');
    }
</script>