<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login - <?= $title; ?></title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,600,700&display=swap">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url('assets/plugins/fontawesome-free/css/all.min.css') ?>">
  <!-- AdminLTE -->
  <link rel="stylesheet" href="<?= base_url('assets/dist/css/adminlte.min.css') ?>">

  <style>
    body {
      background: url('https://www.jabarnews.com/wp-content/uploads/2021/12/iv3rkd2b5s2x.jpg') no-repeat center center fixed;
      background-size: cover;
      font-family: 'Source Sans Pro', sans-serif;
    }

    .login-container {
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .login-box {
    background: rgba(255, 255, 255, 0.25); /* semi-transparan */
    backdrop-filter: blur(16px); /* efek kaca */
    -webkit-backdrop-filter: blur(16px); /* untuk Safari */
    border-radius: 20px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
    padding: 40px 30px;
    width: 100%;
    max-width: 400px;
    }

    .login-box .profile-img {
      width: 90px;
      height: 90px;
      border-radius: 50%;
      object-fit: cover;
      margin: 0 auto 20px;
      display: block;
    }

    .login-box h3 {
      text-align: center;
      margin-bottom: 30px;
      font-weight: 600;
      color: #333;
    }

    .form-control {
      border-radius: 30px;
      padding-left: 45px;
    }

    .input-group-text {
      border-radius: 30px 0 0 30px;
      background: #f1f1f1;
    }

    .btn-login {
      border-radius: 30px;
      font-weight: bold;
    }

    .text-forgot {
      text-align: center;
      margin-top: 10px;
    }
    .login-box {
    animation: fadeIn 1.2s ease;
    }

    @keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(-40px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
    }

  </style>
</head>
<body>
  <div class="login-container">
    <div class="login-box">
      <img src="<?= base_url('assets/data-perusahaan/trijagabaya-small.png') ?>" class="profile-img" alt="Logo">
      <h3>Arifah Karya Nusantara</h3>
      <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
      <?php endif; ?>

      <form method="post" action="<?= base_url('login/aksi_login'); ?>">
        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text"><i class="fas fa-user"></i></span>
          </div>
          <input type="email" name="nama" class="form-control" placeholder="Email" required>
        </div>

        <div class="input-group mb-3">
          <div class="input-group-prepend">
            <span class="input-group-text"><i class="fas fa-lock"></i></span>
          </div>
          <input type="password" name="pass" class="form-control" placeholder="Password" required>
        </div>

        <div class="form-group form-check">
          <input type="checkbox" class="form-check-input" id="remember">
          <label class="form-check-label" for="remember">Ingat saya</label>
        </div>

        <button type="submit" class="btn btn-primary btn-block btn-login">Login</button>
        <p class="text-muted text-forgot"><small><a href="#">Lupa Password?</a></small></p>
      </form>
    </div>
  </div>

  <script src="<?= base_url('assets/plugins/jquery/jquery.min.js') ?>"></script>
  <script src="<?= base_url('assets/plugins/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
  <script src="<?= base_url('assets/dist/js/adminlte.min.js') ?>"></script>
  <script>
  // Isi email otomatis jika cookie ada
  window.onload = function() {
    const savedEmail = localStorage.getItem("remember_email");
    if (savedEmail) {
      document.querySelector('input[name="nama"]').value = savedEmail;
      document.querySelector('input[name="remember"]').checked = true;
    }
  };

  // Simpan email ke localStorage saat submit
  document.querySelector("form").addEventListener("submit", function() {
    const email = document.querySelector('input[name="nama"]').value;
    const remember = document.querySelector('input[name="remember"]').checked;
    if (remember) {
      localStorage.setItem("remember_email", email);
    } else {
      localStorage.removeItem("remember_email");
    }
  });
</script>

</body>
</html>