<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">MASTER PAKET NELFON</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" onclick="aksi_reload()"><i class="fas fa-sync-alt"></i></button>
                    </div>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_paket_nelfon">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>

            <div class="modal-header">
                <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Kode</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_paket_nelfon_kode" name="remoteUrl" placeholder="Kode produk">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Operator</label>
                            <div class="col-lg-9">
                                <select required class="form-control select2bs4 col-sm-2" style="width: 100%;" id="mst_paket_nelfon_operator" name='mst_paket_nelfon_operator' required>Pilih Status
                                    <option value="Telkomsel">Telkomsel</option>
                                    <option value="XL">XL</option>
                                    <option value="Indosat">Indosat</option>
                                    <option value="Axis">Axis</option>
                                    <option value="Tri">Tri</option>
                                    <option value="Smartfren">Smartfren</option>
                                    <option value="ByU">ByU</option>
                                </select>
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Nama</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_paket_nelfon_nama" name="remoteUrl" placeholder="Nama produk">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Keterangan</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_paket_nelfon_keterangan" name="remoteUrl" placeholder="Keterangan">

                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Notasi</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_paket_nelfon_notasi" name="remoteUrl" placeholder="Notasi khusus (promo, cara pakai dll)">
                            </div>
                        </div>
                        <br>

                    </div>

                    <div class="col-md-6">
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Harga</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_paket_nelfon_harga" name="remoteUrl" placeholder="Harga produk">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Admin</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_paket_nelfon_admin" name="remoteUrl" placeholder="Biaya admin">
                            </div>
                        </div>
                        <br>

                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Poin</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_paket_nelfon_poin" name="remoteUrl" placeholder="Poin">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Urutan</label>
                            <div class="col-lg-9">
                                <input type="number" class="form-control" id="mst_paket_nelfon_urutan" name="remoteUrl" placeholder="Urutan">
                            </div>
                        </div>
                    </div>
                </div>



            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                <button type="button" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>

<script type='text/javascript'>
    $(document).ready(function() {
        aksi_data();

        //SELECT2
        $('.select2').select2()
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })

        //FORMAT RUPIAH
        var mst_paket_nelfon_harga = document.getElementById('mst_paket_nelfon_harga');
        mst_paket_nelfon_harga.addEventListener('keyup', function(e) {
            mst_paket_nelfon_harga.value = aksi_rupiah(this.value, '');
        });

        var mst_paket_nelfon_admin = document.getElementById('mst_paket_nelfon_admin');
        mst_paket_nelfon_admin.addEventListener('keyup', function(e) {
            mst_paket_nelfon_admin.value = aksi_rupiah(this.value, '');
        });
    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>master/master_paket_nelfon/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_reload() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>master/master_paket_nelfon/aksi_reload',
            success: function() {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                aksi_data();
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var mst_paket_nelfon_kode = $row.find("#tbl_mst_paket_nelfon_kode").text();;
        var mst_paket_nelfon_operator = $row.find("#tbl_mst_paket_nelfon_operator").text();
        var mst_paket_nelfon_nama = $row.find("#tbl_mst_paket_nelfon_nama").text();
        var mst_paket_nelfon_keterangan = $row.find("#tbl_mst_paket_nelfon_keterangan").text();
        var mst_paket_nelfon_notasi = $row.find("#tbl_mst_paket_nelfon_notasi").text();
        var mst_paket_nelfon_harga = $row.find("#tbl_mst_paket_nelfon_harga").text();
        var mst_paket_nelfon_admin = $row.find("#tbl_mst_paket_nelfon_admin").text();
        var mst_paket_nelfon_poin = $row.find("#tbl_mst_paket_nelfon_poin").text();
        var mst_paket_nelfon_urutan = $row.find("#tbl_mst_paket_nelfon_urutan").text();

        //SET VALUE
        document.getElementById("mst_paket_nelfon_kode").value = mst_paket_nelfon_kode;
        $("#mst_paket_nelfon_operator").val(mst_paket_nelfon_operator).trigger("change");
        document.getElementById("mst_paket_nelfon_nama").value = mst_paket_nelfon_nama;
        document.getElementById("mst_paket_nelfon_keterangan").value = mst_paket_nelfon_keterangan;
        document.getElementById("mst_paket_nelfon_notasi").value = mst_paket_nelfon_notasi;
        document.getElementById("mst_paket_nelfon_harga").value = aksi_rupiah(mst_paket_nelfon_harga, '');
        document.getElementById("mst_paket_nelfon_admin").value = aksi_rupiah(mst_paket_nelfon_admin, '');
        document.getElementById("mst_paket_nelfon_poin").value = mst_paket_nelfon_poin;
        document.getElementById("mst_paket_nelfon_urutan").value = mst_paket_nelfon_urutan;

        //DISABLE VALUE
        document.getElementById("mst_paket_nelfon_kode").readOnly = true;

        //SET TITLE
        $("#modal_title").html('EDIT PAKET NELFON');

        document.getElementById("btn_simpan").onclick = function() {
            aksi_edit();
        }

        //SHOW MODAL
        $('#modal_paket_nelfon').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_edit() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var mst_paket_nelfon_kode = $("#mst_paket_nelfon_kode").val();
        var mst_paket_nelfon_operator = $("#mst_paket_nelfon_operator").val();
        var mst_paket_nelfon_nama = $("#mst_paket_nelfon_nama").val();
        var mst_paket_nelfon_keterangan = $("#mst_paket_nelfon_keterangan").val();
        var mst_paket_nelfon_notasi = $("#mst_paket_nelfon_notasi").val();
        var mst_paket_nelfon_harga = $("#mst_paket_nelfon_harga").val();
        var mst_paket_nelfon_admin = $("#mst_paket_nelfon_admin").val();
        var mst_paket_nelfon_poin = $("#mst_paket_nelfon_poin").val();
        var mst_paket_nelfon_urutan = $("#mst_paket_nelfon_urutan").val();

        if (mst_paket_nelfon_kode.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_operator.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_nama.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_keterangan.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_harga.length < 2) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_admin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_poin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_urutan.length < 1) {
            toastr.error('Data belum lengkap');
        } else {
            document.getElementById("modal_loading").style.visibility = "visible";

            $.ajax({
                url: '<?php echo base_url() ?>master/master_paket_nelfon/aksi_edit',
                type: "POST",
                data: {
                    mst_paket_nelfon_kode: mst_paket_nelfon_kode,
                    mst_paket_nelfon_operator: mst_paket_nelfon_operator,
                    mst_paket_nelfon_nama: mst_paket_nelfon_nama,
                    mst_paket_nelfon_keterangan: mst_paket_nelfon_keterangan,
                    mst_paket_nelfon_notasi: mst_paket_nelfon_notasi,
                    mst_paket_nelfon_harga: mst_paket_nelfon_harga,
                    mst_paket_nelfon_admin: mst_paket_nelfon_admin,
                    mst_paket_nelfon_poin: mst_paket_nelfon_poin,
                    mst_paket_nelfon_urutan: mst_paket_nelfon_urutan
                },
                success: function() {
                    toastr.success('Produk berhasil di edit');

                    //SET VALUE
                    document.getElementById("mst_paket_nelfon_kode").value = '';
                    $("#mst_paket_nelfon_operator").val('').trigger("change");
                    document.getElementById("mst_paket_nelfon_nama").value = '';
                    document.getElementById("mst_paket_nelfon_keterangan").value = '';
                    document.getElementById("mst_paket_nelfon_notasi").value = '';
                    document.getElementById("mst_paket_nelfon_harga").value = '';
                    document.getElementById("mst_paket_nelfon_admin").value = '';
                    document.getElementById("mst_paket_nelfon_poin").value = '';
                    document.getElementById("mst_paket_nelfon_urutan").value = '';

                    //HIDE MODAL
                    document.getElementById("modal_loading").style.visibility = "hidden";
                    $("#modal_paket_nelfon").modal('hide');

                    aksi_data();
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    toastr.success('Produk gagal di edit');
                    document.getElementById("modal_loading").style.visibility = "hidden";
                }
            });
        }
    }

    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH PAKET NELFON');

        //ENABLE VALUE
        document.getElementById("mst_paket_nelfon_kode").readOnly = false;

        //SET VALUE
        document.getElementById("mst_paket_nelfon_kode").value = '';
        $("#mst_paket_nelfon_operator").val('').trigger("change");
        document.getElementById("mst_paket_nelfon_nama").value = '';
        document.getElementById("mst_paket_nelfon_keterangan").value = '';
        document.getElementById("mst_paket_nelfon_notasi").value = '';
        document.getElementById("mst_paket_nelfon_harga").value = '';
        document.getElementById("mst_paket_nelfon_admin").value = '';
        document.getElementById("mst_paket_nelfon_poin").value = '';
        document.getElementById("mst_paket_nelfon_urutan").value = '';

        document.getElementById("btn_simpan").onclick = function() {
            aksi_tambah();
        }

        //SHOW MODAL
        $('#modal_paket_nelfon').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tambah() {
        var mst_paket_nelfon_kode = $("#mst_paket_nelfon_kode").val();
        var mst_paket_nelfon_operator = $("#mst_paket_nelfon_operator").val();
        var mst_paket_nelfon_nama = $("#mst_paket_nelfon_nama").val();
        var mst_paket_nelfon_keterangan = $("#mst_paket_nelfon_keterangan").val();
        var mst_paket_nelfon_notasi = $("#mst_paket_nelfon_notasi").val();
        var mst_paket_nelfon_harga = $("#mst_paket_nelfon_harga").val();
        var mst_paket_nelfon_admin = $("#mst_paket_nelfon_admin").val();
        var mst_paket_nelfon_poin = $("#mst_paket_nelfon_poin").val();
        var mst_paket_nelfon_urutan = $("#mst_paket_nelfon_urutan").val();

        if (mst_paket_nelfon_kode.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_operator.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_nama.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_keterangan.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_harga.length < 2) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_admin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_poin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_paket_nelfon_urutan.length < 1) {
            toastr.error('Data belum lengkap');
        } else {
            document.getElementById("modal_loading").style.visibility = "visible";

            $.ajax({
                url: '<?php echo base_url() ?>master/master_paket_nelfon/aksi_tambah',
                type: "POST",
                data: {
                    mst_paket_nelfon_kode: mst_paket_nelfon_kode,
                    mst_paket_nelfon_operator: mst_paket_nelfon_operator,
                    mst_paket_nelfon_nama: mst_paket_nelfon_nama,
                    mst_paket_nelfon_keterangan: mst_paket_nelfon_keterangan,
                    mst_paket_nelfon_notasi: mst_paket_nelfon_notasi,
                    mst_paket_nelfon_harga: mst_paket_nelfon_harga,
                    mst_paket_nelfon_admin: mst_paket_nelfon_admin,
                    mst_paket_nelfon_poin: mst_paket_nelfon_poin,
                    mst_paket_nelfon_urutan: mst_paket_nelfon_urutan
                },
                success: function(data) {
                    var obj = JSON.parse(data);
                    var tambah_status = obj.tambah_status;

                    if (tambah_status == '0') {
                        toastr.success('Produk berhasil di tambahkan');

                        //SET VALUE
                        document.getElementById("mst_paket_nelfon_kode").value = '';
                        $("#mst_paket_nelfon_operator").val('').trigger("change");
                        document.getElementById("mst_paket_nelfon_nama").value = '';
                        document.getElementById("mst_paket_nelfon_keterangan").value = '';
                        document.getElementById("mst_paket_nelfon_notasi").value = '';
                        document.getElementById("mst_paket_nelfon_harga").value = '';
                        document.getElementById("mst_paket_nelfon_admin").value = '';
                        document.getElementById("mst_paket_nelfon_poin").value = '';
                        document.getElementById("mst_paket_nelfon_urutan").value = '';

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        aksi_data();
                    } else {
                        toastr.error('Produk gagal di tambahkan karena kode produk sudah pernah ditambahkan sebelumnya!');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }

                },
                error: function(xhr, ajaxOptions, thrownError) {
                    toastr.error('Produk gagal di tambahkan');
                    document.getElementById("modal_loading").style.visibility = "hidden";
                }
            });
        }
    }

    function aksi_tidak_aktif(mst_paket_nelfon_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>master/master_paket_nelfon/aksi_tidak_aktif/' + mst_paket_nelfon_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status produk menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status produk menjadi tidak aktif');
            }
        });
    }

    function aksi_aktif(mst_paket_nelfon_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>master/master_paket_nelfon/aksi_aktif/' + mst_paket_nelfon_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status produk menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status produk menjadi tidak aktif');
            }
        });
    }

    function aksi_hapus(mst_paket_nelfon_kode) {
        Swal.fire({
            title: 'Yakin ingin menghapus produk?',
            text: "Setelah menghapus, data tidak bisa dikembalikan lagi!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>master/master_paket_nelfon/aksi_hapus/' + mst_paket_nelfon_kode,
                    type: "POST",
                    success: function() {
                        toastr.success('Berhasil menghapus produk');
                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Gagal menghapus produk');
                    }
                });
            }
        })


    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_paket_nelfon").modal('hide');
    }

    function aksi_rupiah(angka, prefix) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? '' + rupiah : '');
    }
</script>