<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">MASTER WIFI ID</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" onclick="aksi_reload()"><i class="fas fa-sync-alt"></i></button>
                    </div>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_wifiid">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>

            <div class="modal-header">
                <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Kode</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_wifiid_kode" name="remoteUrl" placeholder="Kode produk">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Nama</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_wifiid_nama" name="remoteUrl" placeholder="Nama produk">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Keterangan</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_wifiid_keterangan" name="remoteUrl" placeholder="Keterangan">

                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Notasi</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_wifiid_notasi" name="remoteUrl" placeholder="Notasi khusus (promo, cara pakai dll)">
                            </div>
                        </div>
                        <br>

                    </div>

                    <div class="col-md-6">
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Harga</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_wifiid_harga" name="remoteUrl" placeholder="Harga produk">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Admin</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_wifiid_admin" name="remoteUrl" placeholder="Biaya admin">
                            </div>
                        </div>
                        <br>

                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Poin</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="mst_wifiid_poin" name="remoteUrl" placeholder="Poin">
                            </div>
                        </div>
                        <br>
                        <div class="form-row">
                            <label for="input1" class="col-lg-3 control-label">Urutan</label>
                            <div class="col-lg-9">
                                <input type="number" class="form-control" id="mst_wifiid_urutan" name="remoteUrl" placeholder="Urutan">
                            </div>
                        </div>
                    </div>
                </div>



            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                <button type="button" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>

<script type='text/javascript'>
    $(document).ready(function() {
        aksi_data();

        //SELECT2
        $('.select2').select2()
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })

        //FORMAT RUPIAH
        var mst_wifiid_harga = document.getElementById('mst_wifiid_harga');
        mst_wifiid_harga.addEventListener('keyup', function(e) {
            mst_wifiid_harga.value = aksi_rupiah(this.value, '');
        });

        var mst_wifiid_admin = document.getElementById('mst_wifiid_admin');
        mst_wifiid_admin.addEventListener('keyup', function(e) {
            mst_wifiid_admin.value = aksi_rupiah(this.value, '');
        });
    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>master/master_wifiid/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_reload() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>master/master_wifiid/aksi_reload',
            success: function() {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                aksi_data();
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var mst_wifiid_kode = $row.find("#tbl_mst_wifiid_kode").text();;
        var mst_wifiid_nama = $row.find("#tbl_mst_wifiid_nama").text();
        var mst_wifiid_keterangan = $row.find("#tbl_mst_wifiid_keterangan").text();
        var mst_wifiid_notasi = $row.find("#tbl_mst_wifiid_notasi").text();
        var mst_wifiid_harga = $row.find("#tbl_mst_wifiid_harga").text();
        var mst_wifiid_admin = $row.find("#tbl_mst_wifiid_admin").text();
        var mst_wifiid_poin = $row.find("#tbl_mst_wifiid_poin").text();
        var mst_wifiid_urutan = $row.find("#tbl_mst_wifiid_urutan").text();

        //SET VALUE
        document.getElementById("mst_wifiid_kode").value = mst_wifiid_kode;
        document.getElementById("mst_wifiid_nama").value = mst_wifiid_nama;
        document.getElementById("mst_wifiid_keterangan").value = mst_wifiid_keterangan;
        document.getElementById("mst_wifiid_notasi").value = mst_wifiid_notasi;
        document.getElementById("mst_wifiid_harga").value = aksi_rupiah(mst_wifiid_harga, '');
        document.getElementById("mst_wifiid_admin").value = aksi_rupiah(mst_wifiid_admin, '');
        document.getElementById("mst_wifiid_poin").value = mst_wifiid_poin;
        document.getElementById("mst_wifiid_urutan").value = mst_wifiid_urutan;

        //DISABLE VALUE
        document.getElementById("mst_wifiid_kode").readOnly = true;

        //SET TITLE
        $("#modal_title").html('EDIT WIFI ID');

        document.getElementById("btn_simpan").onclick = function() {
            aksi_edit();
        }

        //SHOW MODAL
        $('#modal_wifiid').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_edit() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var mst_wifiid_kode = $("#mst_wifiid_kode").val();
        var mst_wifiid_nama = $("#mst_wifiid_nama").val();
        var mst_wifiid_keterangan = $("#mst_wifiid_keterangan").val();
        var mst_wifiid_notasi = $("#mst_wifiid_notasi").val();
        var mst_wifiid_harga = $("#mst_wifiid_harga").val();
        var mst_wifiid_admin = $("#mst_wifiid_admin").val();
        var mst_wifiid_poin = $("#mst_wifiid_poin").val();
        var mst_wifiid_urutan = $("#mst_wifiid_urutan").val();

        if (mst_wifiid_kode.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_nama.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_keterangan.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_harga.length < 2) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_admin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_poin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_urutan.length < 1) {
            toastr.error('Data belum lengkap');
        } else {
            document.getElementById("modal_loading").style.visibility = "visible";

            $.ajax({
                url: '<?php echo base_url() ?>master/master_wifiid/aksi_edit',
                type: "POST",
                data: {
                    mst_wifiid_kode: mst_wifiid_kode,
                    mst_wifiid_nama: mst_wifiid_nama,
                    mst_wifiid_keterangan: mst_wifiid_keterangan,
                    mst_wifiid_notasi: mst_wifiid_notasi,
                    mst_wifiid_harga: mst_wifiid_harga,
                    mst_wifiid_admin: mst_wifiid_admin,
                    mst_wifiid_poin: mst_wifiid_poin,
                    mst_wifiid_urutan: mst_wifiid_urutan
                },
                success: function() {
                    toastr.success('Produk berhasil di edit');

                    //SET VALUE
                    document.getElementById("mst_wifiid_kode").value = '';
                    document.getElementById("mst_wifiid_nama").value = '';
                    document.getElementById("mst_wifiid_keterangan").value = '';
                    document.getElementById("mst_wifiid_notasi").value = '';
                    document.getElementById("mst_wifiid_harga").value = '';
                    document.getElementById("mst_wifiid_admin").value = '';
                    document.getElementById("mst_wifiid_poin").value = '';
                    document.getElementById("mst_wifiid_urutan").value = '';

                    //HIDE MODAL
                    document.getElementById("modal_loading").style.visibility = "hidden";
                    $("#modal_wifiid").modal('hide');

                    aksi_data();
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    toastr.success('Produk gagal di edit');
                    document.getElementById("modal_loading").style.visibility = "hidden";
                }
            });
        }
    }

    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH WIFI ID');

        //ENABLE VALUE
        document.getElementById("mst_wifiid_kode").readOnly = false;

        //SET VALUE
        document.getElementById("mst_wifiid_kode").value = '';
        document.getElementById("mst_wifiid_nama").value = '';
        document.getElementById("mst_wifiid_keterangan").value = '';
        document.getElementById("mst_wifiid_notasi").value = '';
        document.getElementById("mst_wifiid_harga").value = '';
        document.getElementById("mst_wifiid_admin").value = '';
        document.getElementById("mst_wifiid_poin").value = '';
        document.getElementById("mst_wifiid_urutan").value = '';

        document.getElementById("btn_simpan").onclick = function() {
            aksi_tambah();
        }

        //SHOW MODAL
        $('#modal_wifiid').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tambah() {
        var mst_wifiid_kode = $("#mst_wifiid_kode").val();
        var mst_wifiid_nama = $("#mst_wifiid_nama").val();
        var mst_wifiid_keterangan = $("#mst_wifiid_keterangan").val();
        var mst_wifiid_notasi = $("#mst_wifiid_notasi").val();
        var mst_wifiid_harga = $("#mst_wifiid_harga").val();
        var mst_wifiid_admin = $("#mst_wifiid_admin").val();
        var mst_wifiid_poin = $("#mst_wifiid_poin").val();
        var mst_wifiid_urutan = $("#mst_wifiid_urutan").val();

        if (mst_wifiid_kode.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_nama.length < 3) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_keterangan.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_harga.length < 2) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_admin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_poin.length < 1) {
            toastr.error('Data belum lengkap');
        } else if (mst_wifiid_urutan.length < 1) {
            toastr.error('Data belum lengkap');
        } else {
            document.getElementById("modal_loading").style.visibility = "visible";

            $.ajax({
                url: '<?php echo base_url() ?>master/master_wifiid/aksi_tambah',
                type: "POST",
                data: {
                    mst_wifiid_kode: mst_wifiid_kode,
                    mst_wifiid_nama: mst_wifiid_nama,
                    mst_wifiid_keterangan: mst_wifiid_keterangan,
                    mst_wifiid_notasi: mst_wifiid_notasi,
                    mst_wifiid_harga: mst_wifiid_harga,
                    mst_wifiid_admin: mst_wifiid_admin,
                    mst_wifiid_poin: mst_wifiid_poin,
                    mst_wifiid_urutan: mst_wifiid_urutan
                },
                success: function(data) {
                    var obj = JSON.parse(data);
                    var tambah_status = obj.tambah_status;

                    if (tambah_status == '0') {
                        toastr.success('Produk berhasil di tambahkan');

                        //SET VALUE
                        document.getElementById("mst_wifiid_kode").value = '';
                        document.getElementById("mst_wifiid_nama").value = '';
                        document.getElementById("mst_wifiid_keterangan").value = '';
                        document.getElementById("mst_wifiid_notasi").value = '';
                        document.getElementById("mst_wifiid_harga").value = '';
                        document.getElementById("mst_wifiid_admin").value = '';
                        document.getElementById("mst_wifiid_poin").value = '';
                        document.getElementById("mst_wifiid_urutan").value = '';

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        aksi_data();
                    } else {
                        toastr.error('Produk gagal di tambahkan karena kode produk sudah pernah ditambahkan sebelumnya!');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }

                },
                error: function(xhr, ajaxOptions, thrownError) {
                    toastr.error('Produk gagal di tambahkan');
                    document.getElementById("modal_loading").style.visibility = "hidden";
                }
            });
        }
    }

    function aksi_tidak_aktif(mst_wifiid_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>master/master_wifiid/aksi_tidak_aktif/' + mst_wifiid_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status produk menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status produk menjadi tidak aktif');
            }
        });
    }

    function aksi_aktif(mst_wifiid_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>master/master_wifiid/aksi_aktif/' + mst_wifiid_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status produk menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status produk menjadi tidak aktif');
            }
        });
    }

    function aksi_hapus(mst_wifiid_kode) {
        Swal.fire({
            title: 'Yakin ingin menghapus produk?',
            text: "Setelah menghapus, data tidak bisa dikembalikan lagi!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>master/master_wifiid/aksi_hapus/' + mst_wifiid_kode,
                    type: "POST",
                    success: function() {
                        toastr.success('Berhasil menghapus produk');
                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Gagal menghapus produk');
                    }
                });
            }
        })


    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_wifiid").modal('hide');
    }

    function aksi_rupiah(angka, prefix) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? '' + rupiah : '');
    }
</script>