<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">INBOX</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" onclick="aksi_reload()"><i class="fas fa-sync-alt"></i></button>
                    </div>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_inbox">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>
            <form enctype="multipart/form-data" id="submit">
                <div class="modal-header">
                    <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                    <button type="button" class="close" onclick="aksi_tutup_modal()" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        <div class="col-md-12">
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Pilih User</label>
                                <div class="offset-sm-0 col-sm-10">
                                    <select required class="form-control select2bs4 " onchange="aksi_pilih()" style="width: 100%;" id="mst_inbox_user_pilih" name='mst_inbox_user_pilih' required>
                                        <option selected="selected"></option>
                                        <option value="Semua">Semua</option>
                                        <option value="Pilih">Pilih</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Cari User</label>
                                <div class="col-lg-10">
                                    <select required class="form-control select2bs4" style="width: 100%;" id="mst_inbox_user_kode" name='mst_inbox_user_kode' required>
                                        <option selected="selected"></option>
                                        <option value="Semua">Semua</option>
                                        <option value="Pilih">Pilih</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Jenis</label>
                                <div class="col-lg-10">
                                    <select required class="form-control select2bs4" onchange="aksi_jenis()" style="width: 100%;" id="mst_inbox_jenis" name='mst_inbox_jenis' required>
                                        <option selected="selected"></option>
                                        <option value="Teks">Teks</option>
                                        <option value="Gambar">Gambar</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Judul</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_inbox_judul" name="mst_inbox_judul" placeholder="Judul Inbox">
                                </div>
                            </div>

                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Gambar</label>
                                <div class="col-lg-10">
                                    <input type="file" class="form-control" id="mst_inbox_gambar" name="mst_inbox_gambar">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Isi</label>
                                <div class="col-lg-10">
                                    <textarea class="form-control" id="mst_inbox_isi" name="mst_inbox_isi"></textarea>
                                </div>
                            </div>
                        </div>


                    </div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                    <button type="submit" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
    $(function() {
        CKEDITOR.replace('mst_inbox_isi', {
            toolbar: [
                ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'],
                {
                    name: 'basicstyles',
                    items: ['Bold', 'Italic', 'Underline']
                },
                {
                    name: 'links',
                    items: ['Link', 'Unlink', 'Anchor']
                },
            ],
            height: '200px'
        });
    });
</script>

<script type='text/javascript'>
    var submit_status;
    $(document).ready(function() {
        var mst_inbox_user_kode;

        $('#mst_inbox_user_kode').on('select2:select', function(e) {
            mst_inbox_user_kode = e.params.data.id;
            console.log(mst_inbox_user_kode);
        });

        document.getElementById("mst_inbox_user_kode").disabled = true;
        aksi_pilih();

        document.getElementById("mst_inbox_gambar").disabled = true;
        aksi_jenis();

        $('#mst_inbox_user_kode').select2({
            placeholder: '-Cari User-',
            theme: 'bootstrap4',
            minimumInputLength: 0,
            ajax: {
                url: "<?php echo base_url(); ?>/inbox/aksi_user",
                type: 'post',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        keyword: params.term
                    };
                },
                processResults: function(response) {
                    return {
                        results: response
                    };
                },
                cache: true

            }
        });

        aksi_data();
    });

    $('#submit').submit(function(e) {
        e.preventDefault();
        var mst_inbox_user_pilih = $("#mst_inbox_user_pilih").val();
        var mst_inbox_user_kode = $("#mst_inbox_user_kode").val();
        var mst_inbox_jenis = $("#mst_inbox_jenis").val();
        var mst_inbox_judul = $("#mst_inbox_judul").val();
        var mst_inbox_isi = CKEDITOR.instances['mst_inbox_isi'].getData();
        var mst_inbox_gambar = $("#mst_inbox_gambar").val();

        //TAMBAH
        if (submit_status == 'Tambah') {
            if (mst_inbox_user_pilih.length < 2) {
                toastr.error('Data belum lengkap');
            } else if (mst_inbox_jenis.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_inbox_judul.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_inbox_isi.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                var formData = new FormData();
                formData.append("mst_inbox_user_pilih", mst_inbox_user_pilih);
                formData.append("mst_inbox_user_kode", mst_inbox_user_kode);
                formData.append("mst_inbox_jenis", mst_inbox_jenis);
                formData.append("mst_inbox_judul", mst_inbox_judul);
                formData.append("mst_inbox_isi", mst_inbox_isi);
                formData.append("mst_inbox_gambar", $("#mst_inbox_gambar")[0].files[0]);

                $.ajax({
                    url: '<?php echo base_url() ?>inbox/aksi_tambah',
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var tambah_status = obj.tambah_status;

                        if (tambah_status == '0') {
                            toastr.success('Inbox berhasil di tambahkan');

                            //SET VALUE
                            $("#mst_inbox_user_pilih").val('').trigger("change");
                            $("#mst_inbox_user_kode").val('').trigger("change");
                            $("#mst_inbox_jenis").val('').trigger("change");
                            document.getElementById("mst_inbox_judul").value = '';
                            CKEDITOR.instances['mst_inbox_isi'].setData('');
                            document.getElementById("mst_inbox_gambar").value = '';

                            //LOADING
                            document.getElementById("modal_loading").style.visibility = "hidden";

                            aksi_data();
                        } else {
                            toastr.error('Inbox gagal ditambahkan!');
                            document.getElementById("modal_loading").style.visibility = "hidden";
                        }

                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Inbox gagal di tambahkan');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>inbox/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH INBOX');

        //ENABLE VALUE
        document.getElementById("mst_inbox_user_kode").readOnly = false;

        //SET VALUE
        $("#mst_inbox_user_pilih").val('').trigger("change");
        $("#mst_inbox_user_kode").val('').trigger("change");
        $("#mst_inbox_jenis").val('').trigger("change");
        document.getElementById("mst_inbox_judul").value = '';
        CKEDITOR.instances['mst_inbox_isi'].setData('');
        document.getElementById("mst_inbox_gambar").value = '';

        //SET STATUS
        submit_status = 'Tambah';

        //SHOW MODAL
        $('#modal_inbox').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_hapus(mst_inbox_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>inbox/aksi_hapus/' + mst_inbox_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil menghapus inbox');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal menghapus inbox');
            }
        });
    }

    function aksi_jenis() {
        var mst_inbox_jenis = $("#mst_inbox_jenis").val();

        if (mst_inbox_jenis == "Teks") {
            document.getElementById("mst_inbox_gambar").disabled = true;
        }

        if (mst_inbox_jenis == "Gambar") {
            document.getElementById("mst_inbox_gambar").disabled = false;
        }
    }

    function aksi_pilih() {
        var mst_inbox_user_pilih = $("#mst_inbox_user_pilih").val();

        if (mst_inbox_user_pilih == "Semua") {
            document.getElementById("mst_inbox_user_kode").disabled = true;
        }

        if (mst_inbox_user_pilih == "Pilih") {
            document.getElementById("mst_inbox_user_kode").disabled = false;
        }
    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_inbox").modal('hide');
    }
</script>