<div class="container-fluid">
    <div class="row">
        <div style="margin-bottom: 10px;" class="col-md-10">
            <input type="text" class="form-control col-md-12" id="txt_cari" placeholder="Cari nama user, nomor hp atau email">

        </div>

        <div style="margin-bottom: 10px;" class="col-md-2">
            <button type="button" id="btn_cari" class="btn btn-primary col-md-12">Cari</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 col-sm-12 col-12">
            <div class="info-box bg-gradient-primary">
                <span class="info-box-icon"><i class="	fas fa-money-bill"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Poin User</span>
                    <span id="statistik_semua_total" class="info-box-number">Loading...</span>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">POIN USER</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id='table' class='table table-bordered table-striped' width='100%'>
                            <thead>
                                <tr>
                                    <th width='100px'>No</th>
                                    <th width='100px'>AKSI</th>
                                    <th width='100px'>KODE USER</th>
                                    <th width='100px'>NAMA USER</th>
                                    <th width='190px'>NOMOR HP</th>
                                    <th width='100px'>EMAIL</th>
                                    <th width='250px'>POIN</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal-poin">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">TAMBAH POIN</h4>
                <button type="button" onclick="aksi_poin()" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Kode user</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="mst_user_kode" placeholder="">
                    </div>
                </div>
                <br>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Nama user</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="mst_user_nama_lengkap" placeholder="">
                    </div>
                </div>
                <br>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Jumlah</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="trx_poin_jumlah" name="trx_poin_jumlah" placeholder="Contoh : 10.000">
                    </div>
                </div>
                <hr>
                <div class="form-row">
                    <label for="input1" class="col-lg-12 control-label">Tulis pesan pengisan poin manual</label>
                </div>
                <hr>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Judul</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="notifikasi_judul" placeholder="Tulis judul">
                    </div>
                </div>
                <br>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Isi</label>
                    <div class="col-lg-10">
                        <textarea class="form-control" id="notifikasi_isi"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" data-dismiss="modal">TUTUP</button>
                <button type="button" onclick="aksi_tambah_poin_user()" class="btn btn-primary">KIRIM</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>




<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
    $(function() {
        CKEDITOR.replace('notifikasi_isi', {
            toolbar: [
                ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'],
                {
                    name: 'basicstyles',
                    items: ['Bold', 'Italic', 'Underline']
                },
                {
                    name: 'links',
                    items: ['Link', 'Unlink', 'Anchor']
                },
            ],
            height: '200px'
        });
    });
</script>

<script type='text/javascript'>
    $(document).ready(function() {

        var txt_cari = $("#txt_cari").val();

        //PANGGIL DATA
        aksi_poin();
        aksi_statistik();

        //ENTER
        var input = document.getElementById("txt_cari");
        input.addEventListener("keypress", function(event) {
            if (event.key === "Enter") {
                event.preventDefault();
                document.getElementById("btn_cari").click();
            }
        });

        //FORMAT RUPIAH
        var trx_poin_jumlah = document.getElementById('trx_poin_jumlah');
        trx_poin_jumlah.addEventListener('keyup', function(e) {
            trx_poin_jumlah.value = aksi_rupiah(this.value, '');
        });

        //CARI
        $('#btn_cari').click(function() {
            var txt_cari = $("#txt_cari").val();
            if (txt_cari.length >= 2) {
                //CLEAR DATA
                var table = $('#table').DataTable();
                table.clear().draw();

                aksi_poin();
                aksi_statistik();
            } else {
                toastr.info('Mohon lengkapi kata kunci pencarian anda!')
            }

        });

        //SELECT2
        $('.select2').select2()
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })

    });


    function aksi_poin() {
        var txt_cari = $("#txt_cari").val();
        $('#table').DataTable({
            "destroy": true,
            "searching": true,
            "processing": true,
            "serverSide": true,
            'scrollX': true,
            'sScrollX': '100%',
            'sScrollY': '500',
            'ordering': false,
            "info": true,
            "paging": true,
            "order": [],
            "ajax": {
                "url": "<?php echo site_url('/poin_user/aksi_poin') ?>",
                "type": "POST",
                data: {
                    txt_cari: txt_cari,
                }
            },
            "dom": "<'row'<'col-sm-12 col-md-12'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-6'f>>" +
                "<'row'<'.col-md-6:eq(0)'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": ["copy", "print"],

        });
    }

    function aksi_statistik() {
        var txt_cari = $("#txt_cari").val();
        document.getElementById("statistik_semua_total").innerHTML = 'Loading...';

        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>poin_user/aksi_statistik',
            data: {
                txt_cari: txt_cari,
            },
            success: function(data) {
                var obj = JSON.parse(data);
                var statistik_semua_total = obj.statistik_semua_total;
                document.getElementById("statistik_semua_total").innerHTML = obj.statistik_semua_total;
            }
        })
    }

    function aksi_tambah_poin_user_modal(element) {
        $("#modal-poin").modal("show");

        var table = $('#table').DataTable();
        var data_row = table.row($(element).closest('tr')).data();

        var mst_user_kode = data_row[2];
        var mst_user_nama_lengkap = data_row[3];

        //SET VALUE
        document.getElementById("mst_user_kode").value = mst_user_kode;
        document.getElementById("mst_user_nama_lengkap").value = mst_user_nama_lengkap;
        document.getElementById("trx_poin_jumlah").value = "";
        document.getElementById("notifikasi_judul").value = "";
        CKEDITOR.instances['notifikasi_isi'].setData("");


        //DISABLE VALUE
        document.getElementById("mst_user_kode").readOnly = true;
        document.getElementById("mst_user_nama_lengkap").readOnly = true;
    }

    function aksi_tambah_poin_user() {
        var mst_user_kode = $("#mst_user_kode").val();
        var mst_user_nama_lengkap = $("#mst_user_nama_lengkap").val();
        var trx_poin_jumlah = $("#trx_poin_jumlah").val();
        var notifikasi_judul = $("#notifikasi_judul").val();
        var notifikasi_isi = CKEDITOR.instances['notifikasi_isi'].getData();

        if (notifikasi_judul.length > 5 && notifikasi_isi.length > 10) {
            Swal.fire({
                title: 'Apakah sudah benar?',
                text: "Pastikan notifikasi menggunakan bahasa yang sopan dan sesuai SOP. Jika menekan tombol kirim dibawah, maka pesan akan masuk ke inbox user.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Kirim!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo base_url() ?>poin_user/aksi_tambah_poin_user',
                        type: "POST",
                        data: {
                            mst_user_kode: mst_user_kode,
                            mst_user_nama_lengkap: mst_user_nama_lengkap,
                            trx_poin_jumlah: trx_poin_jumlah,
                            notifikasi_judul: notifikasi_judul,
                            notifikasi_isi: notifikasi_isi
                        },
                        success: function(data) {
                            var obj = JSON.parse(data);
                            var poin_status = obj.poin_status;
                            if (poin_status == '0') {
                                toastr.success('Berhasil menambahkan poin ' + mst_user_nama_lengkap);
                                $("#modal-poin").modal('hide');

                                //DATA
                                aksi_poin();

                                //CLEAR DATA
                                $('#mst_user_kode').val('');
                                $('#mst_user_nama_lengkap').val('');
                                $('#trx_poin_jumlah').val('');
                                $('#notifikasi_judul').val('');
                                CKEDITOR.instances['notifikasi_isi'].setData('');
                            } else {
                                toastr.error('Gagal menambahkan poin');
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError, data) {
                            var obj = JSON.parse(data);
                            toastr.error('Gagal menambahkan poin');
                        }
                    });

                }
            })
        } else {
            toastr.info('Mohon isi data dengan benar')
        }



    }

    function aksi_rupiah(angka, prefix) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? '' + rupiah : '');
    }
</script>