<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">PRODUK</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" onclick="aksi_data()"><i class="fas fa-sync-alt"></i></button>
                    </div>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_produk">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>
            <form enctype="multipart/form-data" id="submit">
                <div class="modal-header">
                    <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                    <button type="button" class="close" onclick="aksi_tutup_modal()" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        <div class="col-md-12">
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Kode</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_produk_kode" name="mst_produk_kode" placeholder="Nama produk">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Kategori</label>
                                <div class="col-lg-10">
                                    <select class="form-control select2bs4" style="width: 100%;" id="mst_produk_kategori_kode" required>
                                        <?php foreach ($kategori->result() as $row) { ?>
                                            <option value="<?= $row->ktg_produk_kode ?>"><?= $row->ktg_produk_nama ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Nama</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_produk_nama" name="mst_produk_nama" placeholder="Nama produk">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Satuan</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_produk_satuan" name="mst_produk_satuan" placeholder="Contoh : Harga/Pcs">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Harga</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_produk_harga" name="mst_produk_harga" placeholder="Contoh : 10.000">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Diskon</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_produk_diskon" name="mst_produk_diskon" placeholder="Contoh : 2.000">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Deksripsi</label>
                                <div class="col-lg-10">
                                    <textarea class="form-control" id="mst_produk_deskripsi" name="mst_produk_deskripsi"></textarea>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Foto</label>
                                <div class="col-lg-10">
                                    <input type="file" class="form-control" id="mst_produk_foto" name="mst_produk_foto">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Nama Penjual</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_produk_nama_penjual" name="mst_produk_nama_penjual"></textarea>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Nohp Penjual</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_produk_nohp_penjual" name="mst_produk_nohp_penjual"></textarea>
                                </div>
                            </div>
                            <br>
                        </div>


                    </div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                    <button type="submit" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
    $(function() {
        CKEDITOR.replace('mst_produk_deskripsi', {
            toolbar: [
                ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'],
                {
                    name: 'basicstyles',
                    items: ['Bold', 'Italic', 'Underline']
                },
                {
                    name: 'links',
                    items: ['Link', 'Unlink', 'Anchor']
                },
            ],
            height: '200px'
        });
    });
</script>

<script type='text/javascript'>
    var submit_status;
    $(document).ready(function() {
        aksi_data();

        //FORMAT RUPIAH
        var mst_produk_harga = document.getElementById('mst_produk_harga');
        mst_produk_harga.addEventListener('keyup', function(e) {
            mst_produk_harga.value = aksi_rupiah(this.value, '');
        });

        var mst_produk_diskon = document.getElementById('mst_produk_diskon');
        mst_produk_diskon.addEventListener('keyup', function(e) {
            mst_produk_diskon.value = aksi_rupiah(this.value, '');
        });
    });

    $('#submit').submit(function(e) {
        e.preventDefault();
        var mst_produk_kode = $("#mst_produk_kode").val();
        var mst_produk_kategori_kode = $("#mst_produk_kategori_kode").val();
        var mst_produk_nama = $("#mst_produk_nama").val();
        var mst_produk_satuan = $("#mst_produk_satuan").val();
        var mst_produk_harga = $("#mst_produk_harga").val();
        var mst_produk_diskon = $("#mst_produk_diskon").val();
        var mst_produk_deskripsi = CKEDITOR.instances['mst_produk_deskripsi'].getData();
        var mst_produk_foto = $("#mst_produk_foto").val();
        var mst_produk_nama_penjual = $("#mst_produk_nama_penjual").val();
        var mst_produk_nohp_penjual = $("#mst_produk_nohp_penjual").val();

        //EDIT
        if (submit_status == 'Edit') {
            if (mst_produk_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_kategori_kode.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_nama.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_harga.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_diskon.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_deskripsi.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_nama_penjual.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_nohp_penjual.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                var formData = new FormData();
                formData.append("mst_produk_kode", mst_produk_kode);
                formData.append("mst_produk_kategori_kode", mst_produk_kategori_kode);
                formData.append("mst_produk_nama", mst_produk_nama);
                formData.append("mst_produk_satuan", mst_produk_satuan);
                formData.append("mst_produk_harga", mst_produk_harga);
                formData.append("mst_produk_diskon", mst_produk_diskon);
                formData.append("mst_produk_deskripsi", mst_produk_deskripsi);
                formData.append("mst_produk_foto", $("#mst_produk_foto")[0].files[0]);
                formData.append("mst_produk_nama_penjual", mst_produk_nama_penjual);
                formData.append("mst_produk_nohp_penjual", mst_produk_nohp_penjual);

                $.ajax({
                    url: '<?php echo base_url() ?>produk/aksi_edit',
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        toastr.success('Produk berhasil di edit');

                        //SET VALUE
                        document.getElementById("mst_produk_kode").value = "";
                        var newOption = new Option("", "", true, true);
                        $("#mst_produk_kategori_kode").append(newOption).trigger("change");
                        document.getElementById("mst_produk_nama").value = "";
                        document.getElementById("mst_produk_satuan").value = "";
                        document.getElementById("mst_produk_harga").value = "";
                        document.getElementById("mst_produk_diskon").value = "";
                        CKEDITOR.instances['mst_produk_deskripsi'].setData("");
                        document.getElementById("mst_produk_foto").value = "";
                        document.getElementById("mst_produk_nama_penjual").value = "";
                        document.getElementById("mst_produk_nohp_penjual").value = "";

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        //MODAL
                        $("#modal_produk").modal('hide');

                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Produk gagal di edit');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

        //TAMBAH
        if (submit_status == 'Tambah') {
            if (mst_produk_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_kategori_kode.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_nama.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_harga.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_diskon.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_deskripsi.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_foto.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_nama_penjual.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_produk_nohp_penjual.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                var formData = new FormData();
                formData.append("mst_produk_kode", mst_produk_kode);
                formData.append("mst_produk_kategori_kode", mst_produk_kategori_kode);
                formData.append("mst_produk_nama", mst_produk_nama);
                formData.append("mst_produk_satuan", mst_produk_satuan);
                formData.append("mst_produk_harga", mst_produk_harga);
                formData.append("mst_produk_diskon", mst_produk_diskon);
                formData.append("mst_produk_deskripsi", mst_produk_deskripsi);
                formData.append("mst_produk_foto", $("#mst_produk_foto")[0].files[0]);
                formData.append("mst_produk_nama_penjual", mst_produk_nama_penjual);
                formData.append("mst_produk_nohp_penjual", mst_produk_nohp_penjual);

                $.ajax({
                    url: '<?php echo base_url() ?>produk/aksi_tambah',
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var tambah_status = obj.tambah_status;

                        if (tambah_status == '0') {
                            toastr.success('Produk berhasil di tambahkan');

                            //SET VALUE
                            document.getElementById("mst_produk_kode").value = '';
                            var newOption = new Option('', '', true, true);
                            $("#mst_produk_kategori_kode").append(newOption).trigger("change");
                            document.getElementById("mst_produk_nama").value = "";
                            document.getElementById("mst_produk_satuan").value = "";
                            document.getElementById("mst_produk_harga").value = "";
                            document.getElementById("mst_produk_diskon").value = "";
                            CKEDITOR.instances['mst_produk_deskripsi'].setData("");
                            document.getElementById("mst_produk_foto").value = "";
                            document.getElementById("mst_produk_nama_penjual").value = "";
                            document.getElementById("mst_produk_nohp_penjual").value = "";

                            //LOADING
                            document.getElementById("modal_loading").style.visibility = "hidden";

                            aksi_data();
                        } else {
                            toastr.error('Produk gagal di tambahkan karena kode produk sudah pernah ditambahkan sebelumnya!');
                            document.getElementById("modal_loading").style.visibility = "hidden";
                        }

                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Produk gagal di tambahkan');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>produk/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var mst_produk_kode = $row.find("#tbl_mst_produk_kode").text();
        var ktg_produk_nama = $row.find("#tbl_ktg_produk_nama").text();
        var mst_produk_rekomendasi = $row.find("#tbl_mst_produk_rekomendasi").text();
        var mst_produk_kategori_kode = $row.find("#tbl_mst_produk_kategori_kode").text();
        var ktg_produk_nama = $row.find("#tbl_ktg_produk_nama").text();
        var mst_produk_foto = $row.find("#tbl_mst_produk_foto").text();
        var mst_produk_nama = $row.find("#tbl_mst_produk_nama").text();
        var mst_produk_satuan = $row.find("#tbl_mst_produk_satuan").text();
        var mst_produk_harga = $row.find("#tbl_mst_produk_harga").text();
        var mst_produk_diskon = $row.find("#tbl_mst_produk_diskon").text();
        var mst_produk_nama_penjual = $row.find("#tbl_mst_produk_nama_penjual").text();
        var mst_produk_nohp_penjual = $row.find("#tbl_mst_produk_nohp_penjual").text();
        var mst_produk_deskripsi = $row.find("#tbl_mst_produk_deskripsi").text();


        //SET VALUE
        document.getElementById("mst_produk_kode").value = mst_produk_kode;
        var newOption = new Option(ktg_produk_nama, mst_produk_kategori_kode, true, true);
        $("#mst_produk_kategori_kode").append(newOption).trigger("change");
        document.getElementById("mst_produk_nama").value = mst_produk_nama;
        document.getElementById("mst_produk_satuan").value = mst_produk_satuan;
        document.getElementById("mst_produk_harga").value = mst_produk_harga;
        document.getElementById("mst_produk_diskon").value = mst_produk_diskon;
        CKEDITOR.instances['mst_produk_deskripsi'].setData(mst_produk_deskripsi);
        document.getElementById("mst_produk_foto").value = mst_produk_foto;
        document.getElementById("mst_produk_nama_penjual").value = mst_produk_nama_penjual;
        document.getElementById("mst_produk_nohp_penjual").value = mst_produk_nohp_penjual;


        //DISABLE VALUE
        document.getElementById("mst_produk_kode").readOnly = true;

        //SET STATUS
        submit_status = 'Edit';

        //SET TITLE
        $("#modal_title").html('EDIT PRODUK');

        //SHOW MODAL
        $('#modal_produk').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }


    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH PRODUK');

        //ENABLE VALUE
        document.getElementById("mst_produk_kode").readOnly = false;

        //SET VALUE
        document.getElementById("mst_produk_kode").value = "";
        var newOption = new Option("", "", true, true);
        $("#mst_produk_kategori_kode").append(newOption).trigger("change");
        document.getElementById("mst_produk_nama").value = "";
        document.getElementById("mst_produk_satuan").value = "";
        document.getElementById("mst_produk_harga").value = "";
        document.getElementById("mst_produk_diskon").value = "";
        CKEDITOR.instances['mst_produk_deskripsi'].setData("");
        document.getElementById("mst_produk_foto").value = "";
        document.getElementById("mst_produk_nama_penjual").value = "";
        document.getElementById("mst_produk_nohp_penjual").value = "";

        //SET STATUS
        submit_status = 'Tambah';

        //SHOW MODAL
        $('#modal_produk').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_hapus(mst_produk_kode) {
        Swal.fire({
            title: 'Yakin ingin menghapus produk?',
            text: "Setelah menghapus, data tidak bisa dikembalikan lagi!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>produk/aksi_hapus/' + mst_produk_kode,
                    type: "POST",
                    success: function() {
                        toastr.success('Berhasil menghapus Produk');
                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Gagal menghapus Produk');
                    }
                });
            }
        })
    }


    function aksi_tidak_aktif(mst_produk_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>produk/aksi_tidak_aktif/' + mst_produk_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status produk menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status produk menjadi tidak aktif');
            }
        });
    }

    function aksi_aktif(mst_produk_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>produk/aksi_aktif/' + mst_produk_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status produk menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status produk menjadi tidak aktif');
            }
        });
    }

    function aksi_tidak_rekomendasi(mst_produk_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>produk/aksi_tidak_rekomendasi/' + mst_produk_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah rekomendasi produk menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah rekomendasi produk menjadi tidak aktif');
            }
        });
    }

    function aksi_rekomendasi(mst_produk_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>produk/aksi_rekomendasi/' + mst_produk_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah rekomendasi produk menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah rekomendasi produk menjadi tidak aktif');
            }
        });
    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_produk").modal('hide');
    }

    function aksi_rupiah(angka, prefix) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? '' + rupiah : '');
    }
</script>