<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">BANK OTOMATIS</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" onclick="aksi_data()"><i class="fas fa-sync-alt"></i></button>
                    </div>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_bank">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>
            <form enctype="multipart/form-data" id="submit">
                <div class="modal-header">
                    <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                    <button type="button" class="close" onclick="aksi_tutup_modal()" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Kode</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="mst_deposit_kode" name="mst_deposit_kode" placeholder="Kode bank">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Nama</label>
                                <div class="col-lg-9">
                                    <input type="text" class="form-control" id="mst_deposit_nama" name="mst_deposit_nama" placeholder="Nama bank">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Icon</label>
                                <div class="col-lg-9">
                                    <input type="file" class="form-control" id="mst_deposit_icon" name="mst_deposit_icon">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Admin</label>
                                <div class="col-lg-9">
                                    <input type="number" class="form-control" id="mst_deposit_admin" name="mst_deposit_admin" placeholder="Biaya admin yang dibebankan ke user">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-3 control-label">Persen</label>
                                <div class="col-lg-9">
                                    <input type="decimal" class="form-control" id="mst_deposit_persen" name="mst_deposit_persen" step="0.01" min="0" max="100" placeholder="Tambahan biaya admin persentase dari jumlah pengisian">
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                    <button type="submit" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>

<script type='text/javascript'>
    var submit_status;
    $(document).ready(function() {
        aksi_data();
    });

    $('#submit').submit(function(e) {
        e.preventDefault();
        var mst_deposit_kode = $("#mst_deposit_kode").val();
        var mst_deposit_nama = $("#mst_deposit_nama").val();
        var mst_deposit_icon = $("#mst_deposit_icon").val();
        var mst_deposit_admin = $("#mst_deposit_admin").val();
        var mst_deposit_persen = $("#mst_deposit_persen").val();

        //EDIT
        if (submit_status == 'Edit') {
            if (mst_deposit_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_deposit_nama.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_deposit_admin.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                $.ajax({
                    url: '<?php echo base_url() ?>saldo_bank/aksi_edit',
                    type: "POST",
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        toastr.success('Bank berhasil di edit');

                        //SET VALUE
                        document.getElementById("mst_deposit_kode").value = '';
                        document.getElementById("mst_deposit_nama").value = '';
                        document.getElementById("mst_deposit_icon").value = '';
                        document.getElementById("mst_deposit_admin").value = '';
                        document.getElementById("mst_deposit_persen").value = '';

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        //MODAL
                        $("#modal_bank").modal('hide');

                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Bank gagal di edit');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

        //TAMBAH
        if (submit_status == 'Tambah') {
            if (mst_deposit_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_deposit_nama.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_deposit_icon.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_deposit_admin.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                $.ajax({
                    url: '<?php echo base_url() ?>saldo_bank/aksi_tambah',
                    type: "POST",
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var tambah_status = obj.tambah_status;

                        if (tambah_status == '0') {
                            toastr.success('Bank berhasil di tambahkan');

                            //SET VALUE
                            document.getElementById("mst_deposit_kode").value = '';
                            document.getElementById("mst_deposit_nama").value = '';
                            document.getElementById("mst_deposit_icon").value = '';
                            document.getElementById("mst_deposit_admin").value = '';
                            document.getElementById("mst_deposit_persen").value = '';

                            //LOADING
                            document.getElementById("modal_loading").style.visibility = "hidden";

                            aksi_data();
                        } else {
                            toastr.error('Bank gagal di tambahkan karena kode bank sudah pernah ditambahkan sebelumnya!');
                            document.getElementById("modal_loading").style.visibility = "hidden";
                        }

                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Bank gagal di tambahkan');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>saldo_bank/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var mst_deposit_kode = $row.find("#tbl_mst_deposit_kode").text();;
        var mst_deposit_nama = $row.find("#tbl_mst_deposit_nama").text();
        var mst_deposit_admin = $row.find("#tbl_mst_deposit_admin").text();
        var mst_deposit_persen = $row.find("#tbl_mst_deposit_persen").text();

        //SET VALUE
        document.getElementById("mst_deposit_kode").value = mst_deposit_kode;
        document.getElementById("mst_deposit_nama").value = mst_deposit_nama;
        document.getElementById("mst_deposit_admin").value = mst_deposit_admin;
        document.getElementById("mst_deposit_persen").value = mst_deposit_persen;

        //DISABLE VALUE
        document.getElementById("mst_deposit_kode").readOnly = true;

        //SET STATUS
        submit_status = 'Edit';

        //SET TITLE
        $("#modal_title").html('EDIT BANK OTOMATIS');

        //SHOW MODAL
        $('#modal_bank').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH BANK OTOMATIS');

        //ENABLE VALUE
        document.getElementById("mst_deposit_kode").readOnly = false;

        //SET VALUE
        document.getElementById("mst_deposit_kode").value = '';
        document.getElementById("mst_deposit_nama").value = '';
        document.getElementById("mst_deposit_icon").value = '';
        document.getElementById("mst_deposit_admin").value = '';
        document.getElementById("mst_deposit_persen").value = '';

        //SET STATUS
        submit_status = 'Tambah';

        //SHOW MODAL
        $('#modal_bank').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tidak_aktif(mst_deposit_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>saldo_bank/aksi_tidak_aktif/' + mst_deposit_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status bank menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status bank menjadi tidak aktif');
            }
        });
    }

    function aksi_aktif(mst_deposit_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>saldo_bank/aksi_aktif/' + mst_deposit_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status bank menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status bank menjadi tidak aktif');
            }
        });
    }

    function aksi_hapus(mst_deposit_kode) {
        Swal.fire({
            title: 'Yakin ingin menghapus bank?',
            text: "Setelah menghapus, data tidak bisa dikembalikan lagi!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>saldo_bank/aksi_hapus/' + mst_deposit_kode,
                    type: "POST",
                    success: function() {
                        toastr.success('Berhasil menghapus bank');
                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Gagal menghapus bank');
                    }
                });
            }
        })


    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_bank").modal('hide');
    }
</script>