  <div class="container-fluid">
      <div class="row">
          <div style="margin-bottom: 10px;" class="col-md-3">
              <input type="text" class="form-control col-md-12" id="transaksi_tanggal" placeholder="Pilih tanggal">
          </div>

          <div style="margin-bottom: 10px;" class="col-md-7">
              <input type="text" class="form-control col-md-12" id="txt_cari" placeholder="Cari kode transaksi, kategori transaksi, nama produk, status transaksi dan nomor tujuan">

          </div>

          <div style="margin-bottom: 10px;" class="col-md-2">
              <button type="button" id="btn_cari" class="btn btn-primary col-md-12">Cari</button>
          </div>
      </div>

      <div class="row">
          <div class="col-md-3 col-sm-6 col-12">
              <div class="info-box bg-gradient-success">
                  <span class="info-box-icon"><i class="fas fa-chart-line"></i></span>
                  <div class="info-box-content">
                      <span class="info-box-text">Transaksi Sukses</span>
                      <span id="statistik_sukses_total" class="info-box-number">Loading...</span>

                      <div class="progress">
                          <div class="progress-bar" style="width: 100%"></div>
                      </div>
                      <span id="statistik_sukses_jumlah" class="progress-description">
                          Loading...
                      </span>
                  </div>
              </div>
          </div>

          <div class="col-md-3 col-sm-6 col-12">
              <div class="info-box bg-gradient-warning">
                  <span class="info-box-icon"><i class="far fa-clock"></i></span>
                  <div class="info-box-content">
                      <span class="info-box-text">Transaksi Pending</span>
                      <span id="statistik_pending_total" class="info-box-number">Loading...</span>

                      <div class="progress">
                          <div class="progress-bar" style="width: 100%"></div>
                      </div>
                      <span id="statistik_pending_jumlah" class="progress-description">
                          Loading...
                      </span>
                  </div>
              </div>
          </div>

          <!-- fix for small devices only -->
          <div class="clearfix hidden-md-up"></div>

          <div class="col-md-3 col-sm-6 col-12">
              <div class="info-box bg-gradient-danger">
                  <span class="info-box-icon"><i class="fas fa-poop"></i></span>
                  <div class="info-box-content">
                      <span class="info-box-text">Transaksi Gagal</span>
                      <span id="statistik_gagal_total" class="info-box-number">Loading...</span>

                      <div class="progress">
                          <div class="progress-bar" style="width: 100%"></div>
                      </div>
                      <span id="statistik_gagal_jumlah" class="progress-description">
                          Loading...
                      </span>
                  </div>
              </div>
          </div>

          <div class="col-md-3 col-sm-6 col-12">
              <div class="info-box bg-gradient-primary">
                  <span class="info-box-icon"><i class="	fas fa-money-bill"></i></span>
                  <div class="info-box-content">
                      <span class="info-box-text">Semua Transaksi</span>
                      <span id="statistik_semua_total" class="info-box-number">Loading...</span>

                      <div class="progress">
                          <div class="progress-bar" style="width: 100%"></div>
                      </div>
                      <span id="statistik_semua_jumlah" class="progress-description">
                          Loading...
                      </span>
                  </div>
              </div>
          </div>
      </div>

      <div class="row">
          <div class="col-md-12">
              <div class="card card-primary">
                  <div class="card-header">
                      <h3 class="card-title">TRANSAKSI</h3>
                  </div>
                  <div class="card-body">
                      <div class="table-responsive">
                          <table id='table_transaksi' class='table table-bordered table-striped' width='100%'>
                              <thead>
                                  <tr>
                                      <th width='100px'>No</th>
                                      <th width='100px'>STATUS</th>
                                      <th width='150px'>KATEGORI</th>
                                      <th width='100px'>KODE USER</th>
                                      <th width='100px'>NAMA USER</th>
                                      <th width='190px'>KODE TRANSAKSI</th>
                                      <th width='100px'>NOMOR</th>
                                      <th width='250px'>NAMA</th>
                                      <th width='100px'>JUMLAH</th>
                                      <th width='100px'>KETERANGAN</th>
                                      <th width='100px'>NOTASI</th>
                                      <th width='100px'>TANGGAL</th>
                                      <th width='100px'>RC</th>
                                  </tr>
                              </thead>
                          </table>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>


  <script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
  <script type='text/javascript'>
      var today = new Date();
      var dd = String(today.getDate()).padStart(2, '0');
      var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
      var yyyy = today.getFullYear();
      today = yyyy + '/' + mm + '/' + dd;

      var startDate = today;
      var endDate = today;

      $(document).ready(function() {


          var txt_cari = $("#txt_cari").val();

          //PANGGIL DATA
          aksi_transaksi(startDate, endDate);
          aksi_statistik(startDate, endDate);

          //ENTER
          var input = document.getElementById("txt_cari");
          input.addEventListener("keypress", function(event) {
              if (event.key === "Enter") {
                  event.preventDefault();
                  document.getElementById("btn_cari").click();
              }
          });

          //CARI
          $('#btn_cari').click(function() {
              var txt_cari = $("#txt_cari").val();
              if (txt_cari.length >= 2) {
                  //CLEAR DATA
                  var table = $('#table').DataTable();
                  table.clear().draw();

                  aksi_transaksi(startDate, endDate);
                  aksi_statistik(startDate, endDate);
              } else {
                  toastr.info('Mohon lengkapi kata kunci pencarian anda!')
              }

          });

          //TANGGAL
          $('#transaksi_tanggal').daterangepicker({
                  startDate: moment(),
                  endDate: moment(),
                  minDate: '01/01/2020',
                  maxDate: '12/31/2050',
                  dateLimit: {
                      days: 160
                  },
                  showDropdowns: true,
                  showWeekNumbers: true,
                  timePicker: false,
                  timePickerIncrement: 1,
                  timePicker12Hour: true,
                  ranges: {
                      'Hari Ini': [moment(), moment()],
                      'Kemarin': [moment().subtract('days', 1), moment().subtract('days', 1)],
                      '7 Hari Terkahir': [moment().subtract('days', 6), moment()],
                      '30 Hari Terakhir': [moment().subtract('days', 29), moment()],
                      'Bulan Ini': [moment().startOf('month'), moment().endOf('month')],
                      'Bulan Lalu': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')],
                      'Tahun Ini': [moment().startOf('year'), moment().endOf('year')],
                      'Tahun Lalu': [moment().subtract('year', 1).startOf('year'), moment().subtract('year', 1).endOf('year')]
                  },
                  opens: 'left',
                  buttonClasses: ['btn btn-default'],
                  applyClass: 'btn-small btn-primary',
                  cancelClass: 'btn-small',
                  format: 'DD/MM/YYYY',
                  separator: ' to ',
                  locale: {
                      applyLabel: 'Oke',
                      fromLabel: 'Dari',
                      toLabel: 'Ke',
                      customRangeLabel: 'Custom Tanggal',
                      daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
                      monthNames: ['Januari', 'Februari', 'Maret', 'April', 'Mai', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
                      firstDay: 1
                  }
              },
              function(start, end) {
                  console.log("Callback has been called!");
                  $('#transaksi_tanggal span').html(start.format('YYYY/MM/DD') + ' - ' + end.format('YYYY/MM/DD'));
                  startDate = start.format('YYYY/MM/DD');
                  endDate = end.format('YYYY/MM/DD');

                  //CLEAR DATA
                  var table = $('#table').DataTable();
                  table.clear().draw();

                  //CLEAR CARI
                  $('#txt_cari').val('');

                  aksi_transaksi(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
                  aksi_statistik(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
              }
          );
          //Set the initial state of the picker label
          $('#transaksi_tanggal span').html(moment().subtract('days', 29).format('YYYY/MM/DD') + ' - ' + moment().format('YYYY/MM/DD'));

          $('#transaksi_tanggal').on('apply.daterangepicker', function(ev, picker) {
              $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
          });

          //SELECT2
          $('.select2').select2()
          $('.select2bs4').select2({
              theme: 'bootstrap4'
          })

      });




      function aksi_transaksi(startDate, endDate) {
          var txt_cari = $("#txt_cari").val();
          $('#table_transaksi').DataTable({
              "destroy": true,
              "searching": true,
              "processing": true,
              "serverSide": true,
              'scrollX': true,
              'sScrollX': '100%',
              'sScrollY': '500',
              'ordering': false,
              "info": true,
              "paging": true,
              "order": [],
              "ajax": {
                  "url": "<?php echo site_url('/saldo_transaksi/aksi_transaksi') ?>",
                  "type": "POST",
                  data: {
                      startDate: startDate,
                      endDate: endDate,
                      txt_cari: txt_cari,
                  }
              },
              "dom": "<'row'<'col-sm-12 col-md-12'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-6'f>>" +
                  "<'row'<'.col-md-6:eq(0)'tr>>" +
                  "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
              "buttons": ["copy", "print"],

          });
      }

      function aksi_statistik(startDate, endDate) {
          var txt_cari = $("#txt_cari").val();
          document.getElementById("statistik_sukses_total").innerHTML = 'Loading...';
          document.getElementById("statistik_sukses_jumlah").innerHTML = 'Loading...';
          document.getElementById("statistik_pending_total").innerHTML = 'Loading...';
          document.getElementById("statistik_pending_jumlah").innerHTML = 'Loading...';
          document.getElementById("statistik_gagal_total").innerHTML = 'Loading...';
          document.getElementById("statistik_gagal_jumlah").innerHTML = 'Loading...';
          document.getElementById("statistik_semua_total").innerHTML = 'Loading...';
          document.getElementById("statistik_semua_jumlah").innerHTML = 'Loading...';

          $.ajax({
              type: 'POST',
              url: '<?php echo base_url() ?>saldo_transaksi/aksi_statistik',
              data: {
                  startDate: startDate,
                  endDate: endDate,
                  txt_cari: txt_cari,
              },
              success: function(data) {
                  var obj = JSON.parse(data);
                  var statistik_sukses_total = obj.statistik_sukses_total;
                  var statistik_sukses_jumlah = obj.statistik_sukses_jumlah;
                  var statistik_pending_total = obj.statistik_pending_total;
                  var statistik_pending_jumlah = obj.statistik_pending_jumlah;
                  var statistik_gagal_total = obj.statistik_gagal_total;
                  var statistik_gagal_jumlah = obj.statistik_gagal_jumlah;
                  var statistik_semua_total = obj.statistik_semua_total;
                  var statistik_semua_jumlah = obj.statistik_semua_jumlah;


                  document.getElementById("statistik_sukses_total").innerHTML = obj.statistik_sukses_total;
                  document.getElementById("statistik_sukses_jumlah").innerHTML = obj.statistik_sukses_jumlah + ' transaksi';
                  document.getElementById("statistik_pending_total").innerHTML = obj.statistik_pending_total;
                  document.getElementById("statistik_pending_jumlah").innerHTML = obj.statistik_pending_jumlah + ' transaksi';
                  document.getElementById("statistik_gagal_total").innerHTML = obj.statistik_gagal_total;
                  document.getElementById("statistik_gagal_jumlah").innerHTML = obj.statistik_gagal_jumlah + ' transaksi';
                  document.getElementById("statistik_semua_total").innerHTML = obj.statistik_semua_total;
                  document.getElementById("statistik_semua_jumlah").innerHTML = obj.statistik_semua_jumlah + ' transaksi';
              }
          })
      }
  </script>