<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_hadiah_activity_transaksi extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization', 'fcm']);
		$this->methods['index_post']['limit_transaksi'] = 1;
	}

	private $str_mst_user_zona_waktu;
	private $str_mst_user_kode;
	private $str_mst_hadiah_kode;
	private $str_mst_hadiah_nama;

	public function index_post()
	{
		$this->transaksi_hadiah();

		//TIME ZONE
		date_default_timezone_set($this->str_mst_user_zona_waktu);

		$local_tz = new DateTimeZone($this->str_mst_user_zona_waktu);
		$local_time = new DateTime('now', $local_tz);
		$offset = $local_tz->getOffset($local_time) / 3600;

		//USER
		$mst_user_kode = $this->str_mst_user_kode;

		//TRANSAKSI
		$trx_hadiah_kode =  "HADIAH-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		if ($offset == 7) {
			$trx_hadiah_tanggal = date('Y-m-d H:i:s');
		} else if ($offset == 8) {
			$trx_hadiah_tanggal = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' -1 hour'));
		} else if ($offset == 9) {
			$trx_hadiah_tanggal = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' -2 hour'));
		}
		$mst_hadiah_kode = $this->str_mst_hadiah_kode;
		$mst_hadiah_nama = $this->str_mst_hadiah_nama;
		$trx_hadiah_icon = $this->config->item('icon_hadiah');

		//KATEGORI TRANSAKSI
		$trx_transaksi_kategori =  $this->config->item('transaksi_hadiah');

		//CEK HADIAH
		$hadiah = $this->db->query("SELECT * FROM tbl_mst_hadiah WHERE mst_hadiah_kode='$mst_hadiah_kode' AND
									mst_hadiah_periode_awal <= '$trx_hadiah_tanggal' AND
									mst_hadiah_periode_akhir >= '$trx_hadiah_tanggal'");
		if ($hadiah->num_rows() > 0) {
			foreach ($hadiah->result() as $row) {
				$mst_hadiah_kode = $row->mst_hadiah_kode;
				$mst_hadiah_nama = $row->mst_hadiah_nama;
				$mst_hadiah_jenis = $row->mst_hadiah_jenis;
				$mst_hadiah_harga = $row->mst_hadiah_harga;
				$mst_hadiah_sisa = $row->mst_hadiah_stok - $row->mst_hadiah_terpakai;
			}

			//JIKA STOK HADIAH MASIH ADA
			if ($mst_hadiah_sisa > 0) {
				//CEK POIN
				$poin = $this->db->query("SELECT * FROM tbl_mst_poin WHERE 
										mst_poin_user_kode='$mst_user_kode' and 
										mst_poin_jumlah >= '$mst_hadiah_harga'");
				if ($poin->num_rows() > 0) {
					//POIN CUKUP
					//JIKA HADIAH DALAM BENTUK SALDO
					if ($mst_hadiah_jenis == "Saldo") {
						//UPDATE tbl_mst_hadiah
						$this->db->query("UPDATE tbl_mst_hadiah set 
										mst_hadiah_terpakai=mst_hadiah_terpakai + 1
										where
										mst_hadiah_kode='$mst_hadiah_kode'");

						//INSERT KE tbl_trx_hadiah
						$this->db->query("insert into tbl_trx_hadiah (
										trx_hadiah_kode, 
										trx_hadiah_user_kode, 
										trx_hadiah_nama, 
										trx_hadiah_harga,
										trx_hadiah_jenis,
										trx_hadiah_tanggal) values (
										'$trx_hadiah_kode', 
										'$mst_user_kode', 
										'$mst_hadiah_nama', 
										'$mst_hadiah_harga',
										'$mst_hadiah_jenis', 
										'$trx_hadiah_tanggal')");

						//INSERT KE tbl_trx_transaksi
						$this->db->query("insert into tbl_trx_transaksi (
										trx_transaksi_kode, 
										trx_transaksi_user_kode, 
										trx_transaksi_kategori, 
										trx_transaksi_nomor, 
										trx_transaksi_nama, 
										trx_transaksi_jumlah,
										trx_transaksi_keterangan,
										trx_transaksi_notasi, 
										trx_transaksi_tanggal, 
										trx_transaksi_icon, 
										trx_transaksi_rc,
										trx_transaksi_status) values (
										'$trx_hadiah_kode', 
										'$mst_user_kode', 
										'$trx_transaksi_kategori', 
										'Hadiah',
										'$mst_hadiah_nama', 
										'$mst_hadiah_harga', 
										'Bonus saldo dari redeem hadiah',
										'',  
										'$trx_hadiah_tanggal', 
										'$trx_hadiah_icon', 
										'00', 
										'Sukses')");

						//INSERT KE tbl_trx_pendapatan
						$this->db->query("insert into tbl_trx_pendapatan (
										trx_pendapatan_kode, 
										trx_pendapatan_user_kode, 
										trx_pendapatan_kategori, 
										trx_pendapatan_jumlah, 
										trx_pendapatan_tanggal) values (
										'$trx_hadiah_kode', 
										'$mst_user_kode', 
										'$trx_transaksi_kategori',
										'-$mst_hadiah_harga', 
										'$trx_hadiah_tanggal')");

						//UPDATE tbl_mst_saldo
						$this->db->query("UPDATE tbl_mst_saldo set 
									mst_saldo_jumlah=mst_saldo_jumlah + '$mst_hadiah_harga'
									where
									mst_saldo_user_kode='$mst_user_kode'");

						//INSERT KE tbl_trx_poin
						$this->db->query("insert into tbl_trx_poin (
							trx_poin_kode, 
							trx_poin_user_kode, 
							trx_poin_nama, 
							trx_poin_keterangan, 
							trx_poin_jumlah,
							trx_poin_tanggal) values (
							'$trx_hadiah_kode', 
							'$mst_user_kode', 
							'Hadiah',
							'Pengurangan poin dari transaksi redeem hadiah', 
							'-$mst_hadiah_harga', 
							'$trx_hadiah_tanggal')");

						//UPDATE tbl_mst_poin
						$this->db->query("UPDATE tbl_mst_poin set 
										mst_poin_jumlah=mst_poin_jumlah - '$mst_hadiah_harga'
										where
										mst_poin_user_kode='$mst_user_kode'");

						//NOTIFIKASI
						//PANGGIL USER
						$user = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
						if ($user->num_rows() > 0) {
							foreach ($user->result() as $row) {
								$mst_user_firebase = $row->mst_user_firebase;
							}
							$title = "Berhasil!";
							$body = "Selamat kamu berhasil mendapatkan hadiah";
							firebase_notification($title, $body, $mst_user_firebase);
						}

						//RESPONSE JENIS HADIAH SALDO
						$sess["status"] = "11";
						$sess["pesan"] = "Selamat ya! Kamu berhasil mendapatkan hadiah dari Arifah Pulsa. Semoga hadiah yang kamu dapatkan dapat berguna untuk kebutuhanmu. Terus gunakan Arifah Pulsa untuk memenuhi kebutuhanmu dengan mudah dan cepat. Terima kasih telah menggunakan Arifah Pulsa";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode(array()), $keytoken)
						);
						echo json_encode($sess);
					} else {
						//JIKA HADIAH DALAM BENTUK PRODUK
						//UPDATE tbl_mst_hadiah
						$this->db->query("UPDATE tbl_mst_hadiah set 
										mst_hadiah_terpakai=mst_hadiah_terpakai + 1
										where
										mst_hadiah_kode='$mst_hadiah_kode'");

						//INSERT KE tbl_trx_poin
						$this->db->query("insert into tbl_trx_poin (
							trx_poin_kode, 
							trx_poin_user_kode, 
							trx_poin_nama, 
							trx_poin_keterangan, 
							trx_poin_jumlah,
							trx_poin_tanggal) values (
							'$trx_hadiah_kode', 
							'$mst_user_kode', 
							'Hadiah',
							'Pengurangan poin dari transaksi redeem hadiah', 
							'-$mst_hadiah_harga', 
							'$trx_hadiah_tanggal')");

						//UPDATE tbl_mst_poin
						$this->db->query("UPDATE tbl_mst_poin set 
										mst_poin_jumlah=mst_poin_jumlah - '$mst_hadiah_harga'
										where
										mst_poin_user_kode='$mst_user_kode'");

						//INSERT KE tbl_trx_hadiah
						$this->db->query("insert into tbl_trx_hadiah (
									trx_hadiah_kode, 
									trx_hadiah_user_kode, 
									trx_hadiah_nama, 
									trx_hadiah_harga,
									trx_hadiah_jenis,
									trx_hadiah_tanggal) values (
									'$trx_hadiah_kode', 
									'$mst_user_kode', 
									'$mst_hadiah_nama', 
									'$mst_hadiah_harga',
									'$mst_hadiah_jenis', 
									'$trx_hadiah_tanggal')");

						//NOTIFIKASI
						//PANGGIL USER
						$user = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
						if ($user->num_rows() > 0) {
							foreach ($user->result() as $row) {
								$mst_user_firebase = $row->mst_user_firebase;
							}
							$title = "Berhasil!";
							$body = "Selamat kamu berhasil mendapatkan hadiah";
							firebase_notification($title, $body, $mst_user_firebase);
						}

						//RESPONSE JENIS HADIAH SALDO
						$sess["status"] = "22";
						$sess["pesan"] = "Selamat ya! Kamu berhasil mendapatkan hadiah dari Arifah Pulsa. Silahkan chat customer service Arifah Pulsa untuk mempercepat proses pengiriman hadiah kamu. Semoga hadiah yang kamu dapatkan dapat berguna untuk kebutuhanmu. Terus gunakan Arifah Pulsa untuk memenuhi kebutuhanmu dengan mudah dan cepat. Terima kasih telah menggunakan Arifah Pulsa";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode(array()), $keytoken)
						);
						echo json_encode($sess);
					}
				} else {
					//POIN TIDAK CUKUP
					$sess["status"] = "33";
					$sess["pesan"] = "Poin kamu tidak cukup. Pastikan poin kamu cukup sebelum redeem hadiah";
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				}
			} else {
				//JIKA STOK HADIAH SUDAH HABIS
				//STOK HADIAH HABIS
				$sess["status"] = "34";
				$sess["pesan"] = "Maaf ya, saat ini stok hadiah yang kamu inginkan sedang habis. Jangan khawatir, Arifah Pulsa akan selalu menyediakan berbagai hadiah menarik lainnya untuk kamu dapatkan. Tetap gunakan Arifah Pulsa dan kumpulkan poinmu untuk dapatkan hadiah yang lebih menggiurkan di lain waktu. Terima kasih telah menggunakan Arifah Pulsa!";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//HADIAH KADALUARSA
			$sess["status"] = "35";
			$sess["pesan"] = "Mohon maaf, hadiah hanya bisa di redeem selama tanggal yang sudah ditetapkan";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}

	private function transaksi_hadiah()
	{

		$input = decrypt($this->input->post("transaksi_hadiah", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				$array = explode(".....", $data);
				$mst_transaksi = "";
				foreach ($array as $item) {
					$itemArray = explode(":", $item);
					$key = decrypt(trim($itemArray[0]), $this->config->item('key'));
					$value = trim($itemArray[1]);

					//AMBIL KEY TRANSAKSI
					if ($key == 'mst_transaksi') {
						$mst_transaksi = $value;
					}

					//GENERATE POST SELAIN KEY TRANSAKSI
					if ($key != 'mst_transaksi') {
						$this->transaksi_hadiah_request($key, $mst_transaksi, $value);
					}
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function transaksi_hadiah_request($key, $mst_transaksi, $value)
	{
		$transaksi = decrypt($mst_transaksi, $this->config->item('key'));
		$input = decrypt($value, $transaksi);
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				if ($key == 'mst_user_kode') {
					return $this->str_mst_user_kode = $data;
				}

				if ($key == 'mst_user_zona_waktu') {
					return $this->str_mst_user_zona_waktu = $data;
				}

				if ($key == 'mst_hadiah_kode') {
					return $this->str_mst_hadiah_kode = $data;
				}

				if ($key == 'mst_hadiah_nama') {
					return $this->str_mst_hadiah_nama = $data;
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
