<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_isaku_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$isaku = $this->db->query("SELECT * FROM tbl_mst_isaku  order by mst_isaku_urutan asc");

		if ($isaku->num_rows() > 0) {
			foreach ($isaku->result() as $row) {
				$data['isaku'][] = array(
					'mst_isaku_kode' => encrypt($row->mst_isaku_kode, $this->config->item('key')),
					'mst_isaku_nama' => encrypt($row->mst_isaku_nama, $this->config->item('key')),
					'mst_isaku_keterangan' => encrypt($row->mst_isaku_keterangan, $this->config->item('key')),
					'mst_isaku_notasi' => encrypt($row->mst_isaku_notasi, $this->config->item('key')),
					'mst_isaku_harga' => encrypt(number_format($row->mst_isaku_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_isaku_admin' => encrypt(number_format($row->mst_isaku_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_isaku_total' => encrypt(number_format($row->mst_isaku_harga + $row->mst_isaku_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_isaku_poin' => encrypt($row->mst_isaku_poin, $this->config->item('key')),
					'mst_isaku_urutan' => encrypt($row->mst_isaku_urutan, $this->config->item('key')),
					'mst_isaku_status' => encrypt($row->mst_isaku_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
