<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_masa_aktif_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$mst_masa_aktif_operator = $this->mst_masa_aktif_operator();

		//PANGGIL DATA
		$masa_aktif = $this->db->query("SELECT * FROM tbl_mst_masa_aktif WHERE mst_masa_aktif_operator='$mst_masa_aktif_operator' order by mst_masa_aktif_urutan asc");

		if ($masa_aktif->num_rows() > 0) {
			foreach ($masa_aktif->result() as $row) {
				$data['masa_aktif'][] = array(
					'mst_masa_aktif_kode' => encrypt($row->mst_masa_aktif_kode, $this->config->item('key')),
					'mst_masa_aktif_operator' => encrypt($row->mst_masa_aktif_operator, $this->config->item('key')),
					'mst_masa_aktif_nama' => encrypt($row->mst_masa_aktif_nama, $this->config->item('key')),
					'mst_masa_aktif_keterangan' => encrypt($row->mst_masa_aktif_keterangan, $this->config->item('key')),
					'mst_masa_aktif_notasi' => encrypt($row->mst_masa_aktif_notasi, $this->config->item('key')),
					'mst_masa_aktif_harga' => encrypt(number_format($row->mst_masa_aktif_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_masa_aktif_admin' => encrypt(number_format($row->mst_masa_aktif_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_masa_aktif_total' => encrypt(number_format($row->mst_masa_aktif_harga + $row->mst_masa_aktif_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_masa_aktif_poin' => encrypt($row->mst_masa_aktif_poin, $this->config->item('key')),
					'mst_masa_aktif_urutan' => encrypt($row->mst_masa_aktif_urutan, $this->config->item('key')),
					'mst_masa_aktif_status' => encrypt($row->mst_masa_aktif_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_masa_aktif_operator()
	{
		$input = decrypt($this->input->post("mst_masa_aktif_operator", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
