<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_paket_sms_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$mst_paket_sms_operator = $this->mst_paket_sms_operator();

		//PANGGIL DATA
		$paket_sms = $this->db->query("SELECT * FROM tbl_mst_paket_sms WHERE mst_paket_sms_operator='$mst_paket_sms_operator' order by mst_paket_sms_urutan asc");

		if ($paket_sms->num_rows() > 0) {
			foreach ($paket_sms->result() as $row) {
				$data['paket_sms'][] = array(
					'mst_paket_sms_kode' => encrypt($row->mst_paket_sms_kode, $this->config->item('key')),
					'mst_paket_sms_operator' => encrypt($row->mst_paket_sms_operator, $this->config->item('key')),
					'mst_paket_sms_nama' => encrypt($row->mst_paket_sms_nama, $this->config->item('key')),
					'mst_paket_sms_keterangan' => encrypt($row->mst_paket_sms_keterangan, $this->config->item('key')),
					'mst_paket_sms_notasi' => encrypt($row->mst_paket_sms_notasi, $this->config->item('key')),
					'mst_paket_sms_harga' => encrypt(number_format($row->mst_paket_sms_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_paket_sms_admin' => encrypt(number_format($row->mst_paket_sms_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_paket_sms_total' => encrypt(number_format($row->mst_paket_sms_harga + $row->mst_paket_sms_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_paket_sms_poin' => encrypt($row->mst_paket_sms_poin, $this->config->item('key')),
					'mst_paket_sms_urutan' => encrypt($row->mst_paket_sms_urutan, $this->config->item('key')),
					'mst_paket_sms_status' => encrypt($row->mst_paket_sms_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_paket_sms_operator()
	{
		$input = decrypt($this->input->post("mst_paket_sms_operator", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
