<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_produk_activity_rekomendasi extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//STATUS PRODUK 0 = AKTIF, 1 = TIDAK AKTIF
		$produk = $this->db->query("SELECT * FROM tbl_mst_produk where mst_produk_rekomendasi in ('1') and  mst_produk_status in ('0') order by rand()");
		if ($produk->num_rows() > 0) {
			foreach ($produk->result() as $row) {
				$data['produk'][] = array(
					'mst_produk_kode' => encrypt($row->mst_produk_kode, $this->config->item('key')),
					'mst_produk_kategori_kode' => encrypt($row->mst_produk_kategori_kode, $this->config->item('key')),
					'mst_produk_nama' => encrypt($row->mst_produk_nama, $this->config->item('key')),
					'mst_produk_satuan' => encrypt($row->mst_produk_satuan, $this->config->item('key')),
					'mst_produk_harga' => encrypt(number_format($row->mst_produk_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_produk_diskon' => encrypt(number_format($row->mst_produk_diskon, 0, ',', '.'), $this->config->item('key')),
					'mst_produk_deskripsi' => encrypt($row->mst_produk_deskripsi, $this->config->item('key')),
					'mst_produk_foto' => encrypt($row->mst_produk_foto, $this->config->item('key')),
					'mst_produk_nama_penjual' => encrypt($row->mst_produk_nama_penjual, $this->config->item('key')),
					'mst_produk_nohp_penjual' => encrypt($row->mst_produk_nohp_penjual, $this->config->item('key')),
					'mst_produk_rekomendasi' => encrypt($row->mst_produk_rekomendasi, $this->config->item('key')),
					'mst_produk_status' => encrypt($row->mst_produk_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Kategori tersedia";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Kategori tidak ada";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
