<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_profil_edit_activity_simpan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization', 'fcm']);
	}

	private $str_mst_user_kode;
	private $str_mst_user_nama_lengkap;
	private $str_mst_user_nomor_hp;
	private $str_mst_user_email;

	public function index_post()
	{
		$this->transaksi_profil();
		$mst_user_kode = $this->str_mst_user_kode;
		$mst_user_nama_lengkap = $this->str_mst_user_nama_lengkap;
		$mst_user_nomor_hp = $this->str_mst_user_nomor_hp;
		$mst_user_email = $this->str_mst_user_email;

		//CEK USER
		$user = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode' ");
		if ($user->num_rows() > 0) {
			foreach ($user->result() as $row) {
				$db_mst_user_nomor_hp = $row->mst_user_nomor_hp;
			}

			//JIKA MASIH DATA YG LAMA
			if ($mst_user_nomor_hp == $db_mst_user_nomor_hp) {
				//UPDATE tbl_mst_user
				$this->db->query("UPDATE tbl_mst_user set 
								mst_user_nama_lengkap='$mst_user_nama_lengkap',
								mst_user_nomor_hp='$mst_user_nomor_hp',
								mst_user_email='$mst_user_email'
								where
								mst_user_kode='$mst_user_kode'");

				//PANGGIL USER
				$user = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
				if ($user->num_rows() > 0) {
					foreach ($user->result() as $row) {
						$mst_user_firebase = $row->mst_user_firebase;
					}
					$title = "Berhasil!";
					$body = "Profil berhasil diubah";
					firebase_notification($title, $body, $mst_user_firebase);
				}

				$sess["status"] = "001";
				$sess["pesan"] = "Data berhasil disimpan";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			} else {
				//CEK USER
				$cek = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_nomor_hp='$mst_user_nomor_hp'");
				if ($cek->num_rows() > 0) {
					//USER SUDAH ADA
					$sess["status"] = "002";
					$sess["pesan"] = "Gagal mengubah profil, nomor hp sudah ada yang menggunakan. Pastikan menggunakan nomor hp yang lain";
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				} else {
					//UPDATE tbl_mst_user
					$this->db->query("UPDATE tbl_mst_user set 
									mst_user_nama_lengkap='$mst_user_nama_lengkap',
									mst_user_nomor_hp='$mst_user_nomor_hp',
									mst_user_email='$mst_user_email'
									where
									mst_user_kode='$mst_user_kode'");

					//PANGGIL USER
					$user = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
					if ($user->num_rows() > 0) {
						foreach ($user->result() as $row) {
							$mst_user_firebase = $row->mst_user_firebase;
						}
						$title = "Berhasil!";
						$body = "Profil berhasil diubah";
						firebase_notification($title, $body, $mst_user_firebase);
					}

					$sess["status"] = "001";
					$sess["pesan"] = "Data berhasil disimpan";
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				}
			}
		}
	}


	private function transaksi_profil()
	{

		$input = decrypt($this->input->post("transaksi_profil", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				$array = explode(".....", $data);
				$mst_transaksi = "";
				foreach ($array as $item) {
					$itemArray = explode(":", $item);
					$key = decrypt(trim($itemArray[0]), $this->config->item('key'));
					$value = trim($itemArray[1]);

					//AMBIL KEY TRANSAKSI
					if ($key == 'mst_transaksi') {
						$mst_transaksi = $value;
					}

					//GENERATE POST SELAIN KEY TRANSAKSI
					if ($key != 'mst_transaksi') {
						$this->transaksi_profil_request($key, $mst_transaksi, $value);
					}
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function transaksi_profil_request($key, $mst_transaksi, $value)
	{
		$transaksi = decrypt($mst_transaksi, $this->config->item('key'));
		$input = decrypt($value, $transaksi);
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				if ($key == 'mst_user_kode') {
					return $this->str_mst_user_kode = $data;
				}

				if ($key == 'mst_user_nama_lengkap') {
					return $this->str_mst_user_nama_lengkap = $data;
				}

				if ($key == 'mst_user_nomor_hp') {
					return $this->str_mst_user_nomor_hp = $data;
				}

				if ($key == 'mst_user_email') {
					return $this->str_mst_user_email = $data;
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
