<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_pulsa_activity_transaksi extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
		$this->methods['index_post']['limit_transaksi'] = 1;
	}

	private $str_mst_user_zona_waktu;
	private $str_mst_user_kode;
	private $str_mst_pulsa_kode;
	private $str_trx_pulsa_operator;
	private $str_trx_pulsa_nomor;
	private $str_trx_pulsa_nama;
	private $str_trx_pulsa_admin;
	private $str_trx_pulsa_harga;
	private $str_trx_pulsa_poin;
	private $str_trx_pulsa_keterangan;
	private $str_trx_pulsa_notasi;


	public function index_post()
	{
		$this->transaksi_pulsa();
		date_default_timezone_set($this->str_mst_user_zona_waktu);

		//USER
		$mst_user_kode = $this->str_mst_user_kode;

		//PULSA
		$mst_pulsa_kode = $this->str_mst_pulsa_kode;

		//TRANSAKSI
		$trx_pulsa_kode =  "PULSA-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_pulsa_tanggal = date('Y-m-d H:i:s');
		$trx_pulsa_operator = $this->str_trx_pulsa_operator;
		$trx_pulsa_nomor = $this->str_trx_pulsa_nomor;
		$trx_pulsa_nama = $this->str_trx_pulsa_nama;
		$trx_pulsa_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_pulsa_admin);
		$trx_pulsa_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_pulsa_harga);
		$trx_pulsa_total = $trx_pulsa_harga + $trx_pulsa_admin;
		$trx_pulsa_poin = $this->str_trx_pulsa_poin;
		$trx_pulsa_keterangan = $this->str_trx_pulsa_keterangan;
		$trx_pulsa_notasi = $this->str_trx_pulsa_notasi;
		$trx_pulsa_icon = $this->config->item('icon_pulsa');

		//KATEGORI TRANSAKSI
		$trx_transaksi_kategori =  $this->config->item('transaksi_pulsa');


		//CEK SALDO
		$saldo = $this->db->query("SELECT * FROM tbl_mst_saldo WHERE 
									mst_saldo_user_kode='$mst_user_kode' and 
									mst_saldo_jumlah >= '$trx_pulsa_total'");
		if ($saldo->num_rows() > 0) {
			//SALDO CUKUP
			
			//DIGIFLAZZ
			$url = $this->config->item('digiflazz_api_url');
			$header = array(
				'Content-Type: application/json',
			);
			$params = array(
				'username' => $this->config->item('digiflazz_api_username'),
				'commands'=> "topup",
				'ref_id' => $trx_pulsa_kode,
				'hp' => $trx_pulsa_nomor,
				'pulsa_code' => $mst_pulsa_kode,
				'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $trx_pulsa_kode)
			);
			$json = json_encode($params);
			log_message('debug', 'Data yang dikirim: ' . $json);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
			curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			
			$result = curl_exec($ch);
			curl_close($ch);
			
			log_message('debug', 'Respon: ' . $result);

			$response = json_decode($result, true);

			if (isset($response['data'])) {
				$response = $response['data'];

			if (!empty($response['rc'])) {
				$rc = $response['rc'];
				$status = $response['status'];
				$sn = $response['sn'];

				// Mapping untuk RC
				$rcMapping = [
					"39" => "03",
					"00" => "00",
					"06" => "02",
					"07" => "02",
					"13" => "02",
					"14" => "02",
					"20" => "02",
					"106" => "02",
					"204" => "02"
				];

				// Mapping untuk Status
				$statusMapping = [
					"0" => "Pending",
					"1" => "Sukses",
					"2" => "Gagal"
				];

				// Ubah RC dan Status berdasarkan mapping
				if (isset($rcMapping[$rc])) {
					$rc = $rcMapping[$rc];
				}

				if (isset($statusMapping[$status])) {
					$status = $statusMapping[$status];
				}

				// Log transaksi setelah mapping
				log_message('debug', 'Transaksi dengan ref_id: ' . $ref_id . ', Status: ' . $status . ', RC: ' . $rc);

				//TRANSAKSI SUKSES
				if ($rc == "03") {
					//INSERT KE tbl_trx_pulsa
					$this->db->query("insert into tbl_trx_pulsa (
								trx_pulsa_kode, 
								trx_pulsa_user_kode, 
								trx_pulsa_operator, 
								trx_pulsa_nomor, 
								trx_pulsa_nama, 
								trx_pulsa_admin,
								trx_pulsa_harga,
								trx_pulsa_poin,
								trx_pulsa_sn, 
								trx_pulsa_keterangan, 
								trx_pulsa_notasi, 
								trx_pulsa_tanggal,
								trx_pulsa_icon, 
								trx_pulsa_rc,
								trx_pulsa_status) values (
								'$trx_pulsa_kode', 
								'$mst_user_kode', 
								'$trx_pulsa_operator',
								'$trx_pulsa_nomor', 
								'$trx_pulsa_nama', 
								'$trx_pulsa_admin',
								'$trx_pulsa_harga', 
								'$trx_pulsa_poin', 
								'$sn', 
								'$trx_pulsa_keterangan', 
								'Transaksi masih pending, cek status transaksi secara berkala', 
								'$trx_pulsa_tanggal', 
								'$trx_pulsa_icon',
								'$rc',
								'$status')");

					//INSERT KE tbl_trx_transaksi
					$this->db->query("insert into tbl_trx_transaksi (
								trx_transaksi_kode, 
								trx_transaksi_user_kode, 
								trx_transaksi_kategori, 
								trx_transaksi_nomor, 
								trx_transaksi_nama, 
								trx_transaksi_jumlah,
								trx_transaksi_keterangan,
								trx_transaksi_notasi, 
								trx_transaksi_tanggal, 
								trx_transaksi_icon, 
								trx_transaksi_rc,
								trx_transaksi_status) values (
								'$trx_pulsa_kode', 
								'$mst_user_kode', 
								'$trx_transaksi_kategori', 
								'$trx_pulsa_nomor',
								'$trx_pulsa_nama', 
								'$trx_pulsa_total', 
								'$trx_pulsa_keterangan',
								'Transaksi sedang di proses, cek status transaksi secara berkala ',  
								'$trx_pulsa_tanggal', 
								'$trx_pulsa_icon', 
								'$rc', 
								'$status')");

					//UPDATE tbl_mst_saldo
					$this->db->query("UPDATE tbl_mst_saldo set 
									mst_saldo_jumlah=mst_saldo_jumlah - '$trx_pulsa_total'
									where
									mst_saldo_user_kode='$mst_user_kode'");

					//PANGGIL PULSA
					$pulsa = $this->db->query("SELECT * FROM tbl_trx_pulsa 
											WHERE 
											trx_pulsa_kode='$trx_pulsa_kode' and 
											trx_pulsa_user_kode='$mst_user_kode'");
					if ($pulsa->num_rows() > 0) {
						foreach ($pulsa->result() as $row) {
							$data['transaksi'][] = array(
								'trx_pulsa_kode' => encrypt($row->trx_pulsa_kode, $this->config->item('key')),
							);
						}

						//BERHASIL
						$sess["status"] = "11";
						$sess["pesan"] = "Transaksi berhasil dan ditemukan. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode($data), $keytoken)
						);
						echo json_encode($sess);
					} else {
						//BERHASIL TAPI GAGAL MEMANGGIL
						$sess["status"] = "22";
						$sess["pesan"] = "Transaksi berhasil dilakukan. Pergi ke riwayat transaksi untuk melihat detail transaksi kamu";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode(array()), $keytoken)
						);
						echo json_encode($sess);
					}
				} else {
					//GAGAL
					$sess["status"] = "33";
					$sess["pesan"] = $rc . " Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				}
			} else {
				//GAGAL
				$sess["status"] = "34";
				$sess["pesan"] = "Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//SALDO TIDAK CUKUP
			$sess["status"] = "35";
			$sess["pesan"] = "Saldo kamu tidak cukup. Pastikan saldo kamu cukup sebelum melakukan transaksi";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
	}

	private function transaksi_pulsa()
	{

		$input = decrypt($this->input->post("transaksi_pulsa", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				$array = explode(".....", $data);
				$mst_transaksi = "";
				foreach ($array as $item) {
					$itemArray = explode(":", $item);
					$key = decrypt(trim($itemArray[0]), $this->config->item('key'));
					$value = trim($itemArray[1]);

					//AMBIL KEY TRANSAKSI
					if ($key == 'mst_transaksi') {
						$mst_transaksi = $value;
					}

					//GENERATE POST SELAIN KEY TRANSAKSI
					if ($key != 'mst_transaksi') {
						$this->transaksi_pulsa_request($key, $mst_transaksi, $value);
					}
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function transaksi_pulsa_request($key, $mst_transaksi, $value)
	{
		$transaksi = decrypt($mst_transaksi, $this->config->item('key'));
		$input = decrypt($value, $transaksi);
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				if ($key == 'mst_user_kode') {
					return $this->str_mst_user_kode = $data;
				}

				if ($key == 'mst_user_zona_waktu') {
					return $this->str_mst_user_zona_waktu = $data;
				}

				if ($key == 'mst_pulsa_kode') {
					return $this->str_mst_pulsa_kode = $data;
				}

				if ($key == 'trx_pulsa_operator') {
					return $this->str_trx_pulsa_operator = $data;
				}

				if ($key == 'trx_pulsa_nomor') {
					return $this->str_trx_pulsa_nomor = $data;
				}

				if ($key == 'trx_pulsa_nama') {
					return $this->str_trx_pulsa_nama = $data;
				}

				if ($key == 'trx_pulsa_admin') {
					return $this->str_trx_pulsa_admin = $data;
				}

				if ($key == 'trx_pulsa_harga') {
					return $this->str_trx_pulsa_harga = $data;
				}

				if ($key == 'trx_pulsa_poin') {
					return $this->str_trx_pulsa_poin = $data;
				}

				if ($key == 'trx_pulsa_keterangan') {
					return $this->str_trx_pulsa_keterangan = $data;
				}

				if ($key == 'trx_pulsa_notasi') {
					return $this->str_trx_pulsa_notasi = $data;
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
