<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_sakuku_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$sakuku = $this->db->query("SELECT * FROM tbl_mst_sakuku  order by mst_sakuku_urutan asc");

		if ($sakuku->num_rows() > 0) {
			foreach ($sakuku->result() as $row) {
				$data['sakuku'][] = array(
					'mst_sakuku_kode' => encrypt($row->mst_sakuku_kode, $this->config->item('key')),
					'mst_sakuku_nama' => encrypt($row->mst_sakuku_nama, $this->config->item('key')),
					'mst_sakuku_keterangan' => encrypt($row->mst_sakuku_keterangan, $this->config->item('key')),
					'mst_sakuku_notasi' => encrypt($row->mst_sakuku_notasi, $this->config->item('key')),
					'mst_sakuku_harga' => encrypt(number_format($row->mst_sakuku_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_sakuku_admin' => encrypt(number_format($row->mst_sakuku_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_sakuku_total' => encrypt(number_format($row->mst_sakuku_harga + $row->mst_sakuku_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_sakuku_poin' => encrypt($row->mst_sakuku_poin, $this->config->item('key')),
					'mst_sakuku_urutan' => encrypt($row->mst_sakuku_urutan, $this->config->item('key')),
					'mst_sakuku_status' => encrypt($row->mst_sakuku_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
