<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_token_pln_activity_pelanggan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PLN
		$trx_token_pln_pelanggan_nomor = $this->trx_token_pln_pelanggan_nomor();

		//DIGIFLAZZ
		$url = $this->config->item('digiflazz_api_url');

		$header = array(
			'Content-Type: text/plain',
		);

		$data = array(
			'commands' => "pln-subscribe",
			'customer_no' => $trx_token_pln_pelanggan_nomor
		);

		$json = json_encode($data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($result, true)['data'];

		if (!empty($response['name'])) {
			//DIGIFLAZZ
			$customer_no = $response['customer_no'];
			$meter_no = $response['meter_no'];
			$subscriber_id = $response['subscriber_id'];
			$name = $response['name'];
			$segment_power =  str_replace(' ', '', strstr($response['segment_power'], '/', true));
			$daya = ltrim(substr(ltrim($response['segment_power'], '0'), strpos(ltrim($response['segment_power'], '0'), "/") + 1), '0');

			$data['pelanggan'][] = array(
				'trx_token_pln_pelanggan_nomor' => encrypt($customer_no, $this->config->item('key')),
				'trx_token_pln_pelanggan_id' => encrypt($subscriber_id, $this->config->item('key')),
				'trx_token_pln_pelanggan_nama' => encrypt($name, $this->config->item('key')),
				'trx_token_pln_pelanggan_segment' => encrypt($segment_power, $this->config->item('key')),
				'trx_token_pln_pelanggan_daya' => encrypt($daya, $this->config->item('key')),
			);

			//BERHASIL
			$sess["status"] = "001";
			$sess["pesan"] = "Transaksi berhasil dan ditemukan";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			//GAGAL
			$sess["status"] = "002";
			$sess["pesan"] = "Nomor meter/id pelanggan " . $trx_token_pln_pelanggan_nomor . " tidak ditemukan. Pastikan memasukkan nomor meter/id pelanggan yang benar!";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function trx_token_pln_pelanggan_nomor()
	{
		$input = decrypt($this->input->post("trx_token_pln_pelanggan_nomor", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
