<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_deposit_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");

		//DEPOSIT
		$trx_deposit_jumlah = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->trx_deposit_jumlah());


		//DEPOSIT
		$deposit = $this->db->query("SELECT * FROM tbl_mst_deposit");
		if ($deposit->num_rows() > 0) {
			foreach ($deposit->result() as $key => $row) {
				$mst_deposit_admin[$key] = $row->mst_deposit_admin;
				$mst_deposit_persen[$key] = $row->mst_deposit_persen;
				$mst_deposit_total[$key] = $trx_deposit_jumlah + $mst_deposit_admin[$key] + ($trx_deposit_jumlah * ($mst_deposit_persen[$key] / 100));

				if ($mst_deposit_admin[$key] > 0 && floatval($mst_deposit_persen[$key]) > floatval(0.00)) {
					$mst_deposit_keterangan = "Setelah bayar, transaksi akan diproses otomatis oleh " . $row->mst_deposit_nama;
					$mst_deposit_notasi =  number_format($mst_deposit_total[$key], 0, ',', '.') . " adalah total yang kamu bayar nantinya, dengan tambahan biaya admin Rp " . number_format($mst_deposit_admin[$key], 0, ',', '.') . " + Rp " . number_format($trx_deposit_jumlah * ($mst_deposit_persen[$key] / 100), 0, ',', '.') . " (" . floatval($mst_deposit_persen[$key])  . "%) dari " . $row->mst_deposit_nama;
				} else if (floatval($mst_deposit_persen[$key]) > floatval(0.00)) {
					$mst_deposit_keterangan = "Setelah bayar, transaksi otomatis diproses oleh " . $row->mst_deposit_nama;
					$mst_deposit_notasi =  number_format($mst_deposit_total[$key], 0, ',', '.') . " adalah total yang kamu bayar nantinya, dengan tambahan biaya admin Rp " . number_format($trx_deposit_jumlah * ($mst_deposit_persen[$key] / 100), 0, ',', '.') . " (" . floatval($mst_deposit_persen[$key])  . "%) dari " . $row->mst_deposit_nama;
				} else if ($mst_deposit_admin[$key] > 0) {
					$mst_deposit_keterangan = "Setelah bayar, transaksi otomatis diproses oleh " . $row->mst_deposit_nama;
					$mst_deposit_notasi =  number_format($mst_deposit_total[$key], 0, ',', '.') . " adalah total yang kamu bayar nantinya, dengan tambahan biaya admin Rp " . number_format($mst_deposit_admin[$key], 0, ',', '.') . " dari " . $row->mst_deposit_nama;
				}

				$data['deposit'][] = array(
					'mst_deposit_kode' => encrypt($row->mst_deposit_kode, $this->config->item('key')),
					'mst_deposit_nama' => encrypt($row->mst_deposit_nama, $this->config->item('key')),
					'mst_deposit_admin' => encrypt(number_format($row->mst_deposit_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_deposit_persen' => encrypt($row->mst_deposit_persen, $this->config->item('key')),
					'mst_deposit_total' => encrypt(number_format($mst_deposit_total[$key], 0, ',', '.'), $this->config->item('key')),
					'mst_deposit_keterangan' => encrypt($mst_deposit_keterangan, $this->config->item('key')),
					'mst_deposit_notasi' => encrypt($mst_deposit_notasi, $this->config->item('key')),
					'mst_deposit_icon' => encrypt($row->mst_deposit_icon, $this->config->item('key')),
					'mst_deposit_status' => encrypt($row->mst_deposit_status, $this->config->item('key')),
				);
				array_multisort($mst_deposit_total, SORT_ASC, $data['deposit']);
			}


			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function trx_deposit_jumlah()
	{
		$input = decrypt($this->input->post("trx_deposit_jumlah", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
