<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_gas_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//GAS
		$trx_gas_kode = $this->trx_gas_kode();

		//PANGGIL GAS
		$game = $this->db->query("SELECT * FROM tbl_trx_gas 
									WHERE 
									trx_gas_kode='$trx_gas_kode' and 
									trx_gas_user_kode='$mst_user_kode'");
		if ($game->num_rows() > 0) {
			foreach ($game->result() as $row) {
				$data['transaksi'][] = array(
					'trx_gas_kode' => encrypt($row->trx_gas_kode, $this->config->item('key')),
					'trx_gas_user_kode' => encrypt($row->trx_gas_user_kode, $this->config->item('key')),
					'trx_gas_nomor' => encrypt($row->trx_gas_nomor, $this->config->item('key')),
					'trx_gas_nama' => encrypt($row->trx_gas_nama, $this->config->item('key')),
					'trx_gas_admin' => encrypt(number_format($row->trx_gas_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_gas_harga' => encrypt(number_format($row->trx_gas_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_gas_total' => encrypt(number_format($row->trx_gas_admin + $row->trx_gas_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_gas_lembar_tagihan' => encrypt($row->trx_gas_lembar_tagihan, $this->config->item('key')),
					'trx_gas_periode' => encrypt($row->trx_gas_periode, $this->config->item('key')),
					'trx_gas_meter_awal' => encrypt($row->trx_gas_meter_awal, $this->config->item('key')),
					'trx_gas_meter_akhir' => encrypt($row->trx_gas_meter_akhir, $this->config->item('key')),
					'trx_gas_sn' => encrypt($row->trx_gas_sn, $this->config->item('key')),
					'trx_gas_keterangan' => encrypt($row->trx_gas_keterangan, $this->config->item('key')),
					'trx_gas_notasi' => encrypt($row->trx_gas_notasi, $this->config->item('key')),
					'trx_gas_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_gas_tanggal)), $this->config->item('key')),
					'trx_gas_icon' => encrypt($row->trx_gas_icon, $this->config->item('key')),
					'trx_gas_rc' => encrypt($row->trx_gas_rc, $this->config->item('key')),
					'trx_gas_status' => encrypt($row->trx_gas_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_gas_kode()
	{
		$input = decrypt($this->input->post("trx_gas_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
