<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_grab_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$grab = $this->db->query("SELECT * FROM tbl_mst_grab  order by mst_grab_urutan asc");

		if ($grab->num_rows() > 0) {
			foreach ($grab->result() as $row) {
				$data['grab'][] = array(
					'mst_grab_kode' => encrypt($row->mst_grab_kode, $this->config->item('key')),
					'mst_grab_nama' => encrypt($row->mst_grab_nama, $this->config->item('key')),
					'mst_grab_keterangan' => encrypt($row->mst_grab_keterangan, $this->config->item('key')),
					'mst_grab_notasi' => encrypt($row->mst_grab_notasi, $this->config->item('key')),
					'mst_grab_harga' => encrypt(number_format($row->mst_grab_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_grab_admin' => encrypt(number_format($row->mst_grab_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_grab_total' => encrypt(number_format($row->mst_grab_harga + $row->mst_grab_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_grab_poin' => encrypt($row->mst_grab_poin, $this->config->item('key')),
					'mst_grab_urutan' => encrypt($row->mst_grab_urutan, $this->config->item('key')),
					'mst_grab_status' => encrypt($row->mst_grab_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
