<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_indomaret_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$indomaret = $this->db->query("SELECT * FROM tbl_mst_indomaret  order by mst_indomaret_urutan asc");

		if ($indomaret->num_rows() > 0) {
			foreach ($indomaret->result() as $row) {
				$data['indomaret'][] = array(
					'mst_indomaret_kode' => encrypt($row->mst_indomaret_kode, $this->config->item('key')),
					'mst_indomaret_nama' => encrypt($row->mst_indomaret_nama, $this->config->item('key')),
					'mst_indomaret_keterangan' => encrypt($row->mst_indomaret_keterangan, $this->config->item('key')),
					'mst_indomaret_notasi' => encrypt($row->mst_indomaret_notasi, $this->config->item('key')),
					'mst_indomaret_harga' => encrypt(number_format($row->mst_indomaret_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_indomaret_admin' => encrypt(number_format($row->mst_indomaret_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_indomaret_total' => encrypt(number_format($row->mst_indomaret_harga + $row->mst_indomaret_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_indomaret_poin' => encrypt($row->mst_indomaret_poin, $this->config->item('key')),
					'mst_indomaret_urutan' => encrypt($row->mst_indomaret_urutan, $this->config->item('key')),
					'mst_indomaret_status' => encrypt($row->mst_indomaret_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
