<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_mtix_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$mtix = $this->db->query("SELECT * FROM tbl_mst_mtix  order by mst_mtix_urutan asc");

		if ($mtix->num_rows() > 0) {
			foreach ($mtix->result() as $row) {
				$data['mtix'][] = array(
					'mst_mtix_kode' => encrypt($row->mst_mtix_kode, $this->config->item('key')),
					'mst_mtix_nama' => encrypt($row->mst_mtix_nama, $this->config->item('key')),
					'mst_mtix_keterangan' => encrypt($row->mst_mtix_keterangan, $this->config->item('key')),
					'mst_mtix_notasi' => encrypt($row->mst_mtix_notasi, $this->config->item('key')),
					'mst_mtix_harga' => encrypt(number_format($row->mst_mtix_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_mtix_admin' => encrypt(number_format($row->mst_mtix_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_mtix_total' => encrypt(number_format($row->mst_mtix_harga + $row->mst_mtix_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_mtix_poin' => encrypt($row->mst_mtix_poin, $this->config->item('key')),
					'mst_mtix_urutan' => encrypt($row->mst_mtix_urutan, $this->config->item('key')),
					'mst_mtix_status' => encrypt($row->mst_mtix_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
