<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_token_pln_activity_riwayat extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//PAGING
		$page_number = $this->input->post("page_number", true);
		$paging = $page_number * 20 - (20);
		if ($paging == '1') {
			$paging = 0;
		}

		//FILTER
		$trx_token_pln_tanggal_awal = $this->trx_token_pln_tanggal_awal();
		$trx_token_pln_tanggal_akhir = $this->trx_token_pln_tanggal_akhir();

		//FILTER
		if (strlen($trx_token_pln_tanggal_awal) > 1 && strlen($trx_token_pln_tanggal_akhir) > 1) {
			//PANGGIL DATA
			$token_pln = $this->db->query("SELECT * FROM tbl_trx_token_pln WHERE 
								trx_token_pln_user_kode='$mst_user_kode' AND
								trx_token_pln_tanggal BETWEEN '$trx_token_pln_tanggal_awal 00:00:00' and '$trx_token_pln_tanggal_akhir 23:59:59'
								ORDER BY trx_token_pln_id desc
								limit 20 offset $paging");
		} else {
			//PANGGIL DATA
			$token_pln = $this->db->query("SELECT * FROM tbl_trx_token_pln WHERE 
								trx_token_pln_user_kode='$mst_user_kode'
								ORDER BY trx_token_pln_id desc
								limit 20 offset $paging");
		}

		if ($token_pln->num_rows() > 0) {
			foreach ($token_pln->result() as $row) {
				$data['riwayat'][] = array(
					'trx_token_pln_kode' => encrypt($row->trx_token_pln_kode, $this->config->item('key')),
					'trx_token_pln_user_kode' => encrypt($row->trx_token_pln_user_kode, $this->config->item('key')),
					'trx_token_pln_pelanggan_nomor' => encrypt($row->trx_token_pln_pelanggan_nomor, $this->config->item('key')),
					'trx_token_pln_pelanggan_id' => encrypt($row->trx_token_pln_pelanggan_id, $this->config->item('key')),
					'trx_token_pln_pelanggan_nama' => encrypt($row->trx_token_pln_pelanggan_nama, $this->config->item('key')),
					'trx_token_pln_pelanggan_segment' => encrypt($row->trx_token_pln_pelanggan_segment, $this->config->item('key')),
					'trx_token_pln_pelanggan_daya' => encrypt($row->trx_token_pln_pelanggan_daya, $this->config->item('key')),
					'trx_token_pln_nama' => encrypt($row->trx_token_pln_nama, $this->config->item('key')),
					'trx_token_pln_admin' => encrypt(number_format($row->trx_token_pln_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_token_pln_harga' => encrypt(number_format($row->trx_token_pln_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_token_pln_total' => encrypt(number_format($row->trx_token_pln_admin + $row->trx_token_pln_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_token_pln_poin' => encrypt($row->trx_token_pln_poin, $this->config->item('key')),
					'trx_token_pln_sn' => encrypt($row->trx_token_pln_sn, $this->config->item('key')),
					'trx_token_pln_keterangan' => encrypt($row->trx_token_pln_keterangan, $this->config->item('key')),
					'trx_token_pln_notasi' => encrypt($row->trx_token_pln_notasi, $this->config->item('key')),
					'trx_token_pln_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_token_pln_tanggal)), $this->config->item('key')),
					'trx_token_pln_icon' => encrypt($row->trx_token_pln_icon, $this->config->item('key')),
					'trx_token_pln_rc' => encrypt($row->trx_token_pln_rc, $this->config->item('key')),
					'trx_token_pln_status' => encrypt($row->trx_token_pln_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal menampilkan data, silahkan refresh halaman secara berkala atau hubungi customer service jika masih terjadi kendala!";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_token_pln_tanggal_awal()
	{
		$input = decrypt($this->input->post("trx_token_pln_tanggal_awal", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_token_pln_tanggal_akhir()
	{
		$input = decrypt($this->input->post("trx_token_pln_tanggal_akhir", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
