<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_tv_activity_kategori extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$tv = $this->db->query("SELECT * FROM tbl_ktg_tv where ktg_tv_status in ('0','1') order by ktg_tv_urutan asc");
		if ($tv->num_rows() > 0) {
			foreach ($tv->result() as $row) {
				$data['kategori'][] = array(
					'ktg_tv_kode' => encrypt($row->ktg_tv_kode, $this->config->item('key')),
					'ktg_tv_nama' => encrypt($row->ktg_tv_nama, $this->config->item('key')),
					'ktg_tv_icon' => encrypt($row->ktg_tv_icon, $this->config->item('key')),
					'ktg_tv_urutan' => encrypt($row->ktg_tv_urutan, $this->config->item('key')),
					'ktg_tv_keterangan' => encrypt($row->ktg_tv_keterangan, $this->config->item('key')),
					'ktg_tv_notasi' => encrypt($row->ktg_tv_notasi, $this->config->item('key')),
					'ktg_tv_status' => encrypt($row->ktg_tv_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Kategori tersedia";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Kategori tidak ada";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
