<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_bpjs_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//BPJS
		$trx_bpjs_kode = $this->trx_bpjs_kode();

		//PANGGIL BPJS
		$game = $this->db->query("SELECT * FROM tbl_trx_bpjs 
									WHERE 
									trx_bpjs_kode='$trx_bpjs_kode' and 
									trx_bpjs_user_kode='$mst_user_kode'");
		if ($game->num_rows() > 0) {
			foreach ($game->result() as $row) {
				$data['transaksi'][] = array(
					'trx_bpjs_kode' => encrypt($row->trx_bpjs_kode, $this->config->item('key')),
					'trx_bpjs_user_kode' => encrypt($row->trx_bpjs_user_kode, $this->config->item('key')),
					'trx_bpjs_nomor' => encrypt($row->trx_bpjs_nomor, $this->config->item('key')),
					'trx_bpjs_nama' => encrypt($row->trx_bpjs_nama, $this->config->item('key')),
					'trx_bpjs_admin' => encrypt(number_format($row->trx_bpjs_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_bpjs_harga' => encrypt(number_format($row->trx_bpjs_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_bpjs_total' => encrypt(number_format($row->trx_bpjs_admin + $row->trx_bpjs_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_bpjs_jumlah_peserta' => encrypt($row->trx_bpjs_jumlah_peserta, $this->config->item('key')),
					'trx_bpjs_lembar_tagihan' => encrypt($row->trx_bpjs_lembar_tagihan, $this->config->item('key')),
					'trx_bpjs_alamat' => encrypt($row->trx_bpjs_alamat, $this->config->item('key')),
					'trx_bpjs_periode' => encrypt($row->trx_bpjs_periode, $this->config->item('key')),
					'trx_bpjs_sn' => encrypt($row->trx_bpjs_sn, $this->config->item('key')),
					'trx_bpjs_keterangan' => encrypt($row->trx_bpjs_keterangan, $this->config->item('key')),
					'trx_bpjs_notasi' => encrypt($row->trx_bpjs_notasi, $this->config->item('key')),
					'trx_bpjs_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_bpjs_tanggal)), $this->config->item('key')),
					'trx_bpjs_icon' => encrypt($row->trx_bpjs_icon, $this->config->item('key')),
					'trx_bpjs_rc' => encrypt($row->trx_bpjs_rc, $this->config->item('key')),
					'trx_bpjs_status' => encrypt($row->trx_bpjs_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_bpjs_kode()
	{
		$input = decrypt($this->input->post("trx_bpjs_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
