<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_bpjs_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//BPJS
		$trx_bpjs_kode =  "BPJS-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_bpjs_nomor = $this->trx_bpjs_nomor();

		//DIGIFLAZZ
		$url = $this->config->item('digiflazz_api_url');
		$header = array(
			'Content-Type: text/plain',
		);
		$params = array(
			'commands' => 'inq-pasca',
			'username' => $this->config->item('digiflazz_api_username'),
			'buyer_sku_code' => 'bpjs_kesehatan',
			'customer_no' => $trx_bpjs_nomor,
			'ref_id' => $trx_bpjs_kode,
			'testing' => $this->config->item('digiflazz_api_testing'),
			'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $trx_bpjs_kode)
		);
		$json = json_encode($params);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($result, true)['data'];

		if (!empty($response['rc'])) {
			//DIGIFLAZZ
			$rc = $response['rc'];
			$message = $response['message'];
			$customer_no = $response['customer_no'];
			$customer_name = ucwords(strtolower($response['customer_name']));
			$admin = $this->config->item('admin_bpjs');
			$selling_price = $response['selling_price'];
			$total = $admin + $selling_price;
			$desc = $response['desc'];
			$jumlah_peserta = $desc['jumlah_peserta'];
			$lembar_tagihan = $desc['lembar_tagihan'];
			$alamat = ucwords(strtolower($desc['alamat']));
			$detail = $desc['detail'][0];
			$periode = $this->bulan($detail['periode']);

			//SUKSES
			if ($rc == "00") {
				$data['bpjs'][] = array(
					'trx_bpjs_kode' => encrypt($trx_bpjs_kode, $this->config->item('key')),
					'trx_bpjs_nomor' => encrypt($customer_no, $this->config->item('key')),
					'trx_bpjs_nama' => encrypt($customer_name, $this->config->item('key')),
					'trx_bpjs_admin' => encrypt(number_format($admin, 0, ',', '.'), $this->config->item('key')),
					'trx_bpjs_harga' => encrypt(number_format($selling_price, 0, ',', '.'), $this->config->item('key')),
					'trx_bpjs_total' => encrypt(number_format($total, 0, ',', '.'), $this->config->item('key')),
					'trx_bpjs_jumlah_peserta' => encrypt($jumlah_peserta, $this->config->item('key')),
					'trx_bpjs_lembar_tagihan' => encrypt($lembar_tagihan, $this->config->item('key')),
					'trx_bpjs_alamat' => encrypt($alamat, $this->config->item('key')),
					'trx_bpjs_periode' => encrypt($periode, $this->config->item('key')),
					'trx_bpjs_keterangan' => encrypt("-", $this->config->item('key')),
					'trx_bpjs_notasi' => encrypt("-", $this->config->item('key')),
				);

				//BERHASIL
				$sess["status"] = "11";
				$sess["pesan"] = "Transaksi berhasil dan ditemukan";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode($data), $keytoken)
				);
				echo json_encode($sess);
			} else if ($rc == "60") {
				//TAGIHAN BELUM ADA
				$sess["status"] = "22";
				$sess["pesan"] = $rc . " Tagihan belum tersedia untuk " . $trx_bpjs_nomor . " Mohon dicek lagi secara berkala dan pastikan nomor yang kamu masukkan sudah benar.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			} else {
				//GAGAL
				$sess["status"] = "33";
				$sess["pesan"] = $rc . " Transaksi gagal. Silahkan laporkan pesan tersebut ke customer service jika ada pertanyaan lebih lanjut.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//GAGAL
			$sess["status"] = "34";
			$sess["pesan"] = "Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function trx_bpjs_nomor()
	{
		$input = decrypt($this->input->post("trx_bpjs_nomor", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function bulan($bulan)
	{
		if ($bulan == "01") {
			$bulan = "Jan";
		} else if ($bulan == "02") {
			$bulan = "Feb";
		} else if ($bulan == "03") {
			$bulan = "Mar";
		} else if ($bulan == "04") {
			$bulan = "Apr";
		} else if ($bulan == "05") {
			$bulan = "Mei";
		} else if ($bulan == "06") {
			$bulan = "Jun";
		} else if ($bulan == "07") {
			$bulan = "Jul";
		} else if ($bulan == "08") {
			$bulan = "Agu";
		} else if ($bulan == "09") {
			$bulan = "September";
		} else if ($bulan == "10") {
			$bulan = "Okt";
		} else if ($bulan == "11") {
			$bulan = "Nov";
		} else if ($bulan == "12") {
			$bulan = "Des";
		}
		return $bulan;
	}
}
