<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_brizzi_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$brizzi = $this->db->query("SELECT * FROM tbl_mst_brizzi  order by mst_brizzi_urutan asc");

		if ($brizzi->num_rows() > 0) {
			foreach ($brizzi->result() as $row) {
				$data['brizzi'][] = array(
					'mst_brizzi_kode' => encrypt($row->mst_brizzi_kode, $this->config->item('key')),
					'mst_brizzi_nama' => encrypt($row->mst_brizzi_nama, $this->config->item('key')),
					'mst_brizzi_keterangan' => encrypt($row->mst_brizzi_keterangan, $this->config->item('key')),
					'mst_brizzi_notasi' => encrypt($row->mst_brizzi_notasi, $this->config->item('key')),
					'mst_brizzi_harga' => encrypt(number_format($row->mst_brizzi_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_brizzi_admin' => encrypt(number_format($row->mst_brizzi_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_brizzi_total' => encrypt(number_format($row->mst_brizzi_harga + $row->mst_brizzi_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_brizzi_poin' => encrypt($row->mst_brizzi_poin, $this->config->item('key')),
					'mst_brizzi_urutan' => encrypt($row->mst_brizzi_urutan, $this->config->item('key')),
					'mst_brizzi_status' => encrypt($row->mst_brizzi_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
