<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_doku_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$doku = $this->db->query("SELECT * FROM tbl_mst_doku  order by mst_doku_urutan asc");

		if ($doku->num_rows() > 0) {
			foreach ($doku->result() as $row) {
				$data['doku'][] = array(
					'mst_doku_kode' => encrypt($row->mst_doku_kode, $this->config->item('key')),
					'mst_doku_nama' => encrypt($row->mst_doku_nama, $this->config->item('key')),
					'mst_doku_keterangan' => encrypt($row->mst_doku_keterangan, $this->config->item('key')),
					'mst_doku_notasi' => encrypt($row->mst_doku_notasi, $this->config->item('key')),
					'mst_doku_harga' => encrypt(number_format($row->mst_doku_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_doku_admin' => encrypt(number_format($row->mst_doku_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_doku_total' => encrypt(number_format($row->mst_doku_harga + $row->mst_doku_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_doku_poin' => encrypt($row->mst_doku_poin, $this->config->item('key')),
					'mst_doku_urutan' => encrypt($row->mst_doku_urutan, $this->config->item('key')),
					'mst_doku_status' => encrypt($row->mst_doku_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
