<?php
// File: application/controllers/login_activity/v1/Api_verify_otp.php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_verify_otp extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->helper(['url', 'security', 'hash_helper', 'key_helper']);
        $this->load->model('Otp_model');
        $this->load->model('User_model');
    }

    /**
     * Endpoint: POST /login_activity/v1/Api_verify_otp
     */
    public function index()
    {
        header('Content-Type: application/json; charset=utf-8');

        // 1. Hanya terima POST
        if ($this->input->method() !== 'post') {
            echo json_encode(['status'=>false, 'message'=>'Method tidak diizinkan']);
            return;
        }

        // 2. Ambil input nomor HP terenkripsi & kode OTP
        $enc_nomor = $this->input->post('nomor_hp', true);
        $otp_code  = $this->input->post('otp', true);

        // 3. Validasi input
        if (empty($enc_nomor) || empty($otp_code)) {
            echo json_encode(['status'=>false, 'message'=>'Nomor HP dan OTP dibutuhkan']);
            return;
        }

        // 4. Dekripsi nomor HP dengan key project
        $nomor_hp = decrypt($enc_nomor, get_key());
        if ($nomor_hp === false) {
            echo json_encode(['status'=>false, 'message'=>'Data nomor HP tidak valid']);
            return;
        }

        // 5. Validasi OTP di database (5 menit terakhir)
        $row = $this->Otp_model->get_valid_otp($nomor_hp, $otp_code);
        if (!$row) {
            echo json_encode(['status'=>false, 'message'=>'OTP salah atau kadaluarsa']);
            return;
        }

        // 6. Hapus OTP setelah berhasil verifikasi agar tidak reuse
        if (method_exists($this->Otp_model, 'delete_otp')) {
            $this->Otp_model->delete_otp($nomor_hp, $otp_code);
        } else {
            // Fallback error log jika method tidak ada
            error_log('Otp_model->delete_otp tidak ditemukan!');
        }

        // 7. Ambil user dari DB, buat jika belum ada
        $user = $this->User_model->get_by_nomor_hp($nomor_hp);
        if (!$user) {
            $this->User_model->insert_user([
                'mst_user_nama_lengkap'    => '',
                'mst_user_nomor_hp'        => $nomor_hp,
                'mst_user_pin'             => '',
                'mst_user_tipe'            => 'Normal',
                'mst_user_referal_kode'    => '',
                'mst_user_token'           => '',
                'mst_user_status'          => 'aktif',
                'mst_user_tanggal_daftar'  => date('Y-m-d H:i:s'),
            ]);
            $user = $this->User_model->get_by_nomor_hp($nomor_hp);
        }

        // 8. Generate token jika belum ada
        $token_plain = isset($user['mst_user_token']) ? $user['mst_user_token'] : '';
        if (empty($token_plain)) {
            $token_plain = 'TK'.substr(sha1(uniqid()),0,16).rand(1000,9999);
            $this->User_model->update_token($user['mst_user_kode'], $token_plain);
            $user['mst_user_token'] = $token_plain;
        }

        // 9. **Pastikan semua field yang diperlukan ada, aman untuk dienkripsi**
        //    Jika field tidak ada atau NULL, beri string kosong
        $json_user = [
            'mst_user_kode'         => isset($user['mst_user_kode'])         ? encrypt($user['mst_user_kode'], get_key())         : '',
            'mst_user_nama_lengkap' => isset($user['mst_user_nama_lengkap']) ? encrypt($user['mst_user_nama_lengkap'], get_key()) : '',
            'mst_user_nomor_hp'     => isset($user['mst_user_nomor_hp'])     ? encrypt($user['mst_user_nomor_hp'], get_key())     : '',
            'mst_user_email'        => isset($user['mst_user_email'])        ? encrypt($user['mst_user_email'], get_key())        : '',
            'mst_user_tipe'         => isset($user['mst_user_tipe'])         ? encrypt($user['mst_user_tipe'], get_key())         : '',
            'mst_user_referal_kode' => isset($user['mst_user_referal_kode']) ? encrypt($user['mst_user_referal_kode'], get_key()) : '',
            'mst_user_referal_bonus'=> isset($user['mst_user_referal_bonus'])? encrypt($user['mst_user_referal_bonus'], get_key()): '',
            'mst_user_token'        => isset($user['mst_user_token'])        ? encrypt($user['mst_user_token'], get_key())        : '',
            'mst_user_zona_waktu'   => isset($user['mst_user_zona_waktu'])   ? encrypt($user['mst_user_zona_waktu'], get_key())   : '',
            'mst_user_status'       => isset($user['mst_user_status'])       ? encrypt($user['mst_user_status'], get_key())       : '',
        ];

        // 10. Response sukses
        echo json_encode([
            'status' => true,
            'user'   => $json_user
        ]);
    }
}
