<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_materai_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$materai = $this->db->query("SELECT * FROM tbl_mst_materai  order by mst_materai_urutan asc");

		if ($materai->num_rows() > 0) {
			foreach ($materai->result() as $row) {
				$data['materai'][] = array(
					'mst_materai_kode' => encrypt($row->mst_materai_kode, $this->config->item('key')),
					'mst_materai_nama' => encrypt($row->mst_materai_nama, $this->config->item('key')),
					'mst_materai_keterangan' => encrypt($row->mst_materai_keterangan, $this->config->item('key')),
					'mst_materai_notasi' => encrypt($row->mst_materai_notasi, $this->config->item('key')),
					'mst_materai_harga' => encrypt(number_format($row->mst_materai_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_materai_admin' => encrypt(number_format($row->mst_materai_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_materai_total' => encrypt(number_format($row->mst_materai_harga + $row->mst_materai_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_materai_poin' => encrypt($row->mst_materai_poin, $this->config->item('key')),
					'mst_materai_urutan' => encrypt($row->mst_materai_urutan, $this->config->item('key')),
					'mst_materai_status' => encrypt($row->mst_materai_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
