<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_maxim_driver_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$maxim_driver = $this->db->query("SELECT * FROM tbl_mst_maxim_driver  order by mst_maxim_driver_urutan asc");

		if ($maxim_driver->num_rows() > 0) {
			foreach ($maxim_driver->result() as $row) {
				$data['maxim_driver'][] = array(
					'mst_maxim_driver_kode' => encrypt($row->mst_maxim_driver_kode, $this->config->item('key')),
					'mst_maxim_driver_nama' => encrypt($row->mst_maxim_driver_nama, $this->config->item('key')),
					'mst_maxim_driver_keterangan' => encrypt($row->mst_maxim_driver_keterangan, $this->config->item('key')),
					'mst_maxim_driver_notasi' => encrypt($row->mst_maxim_driver_notasi, $this->config->item('key')),
					'mst_maxim_driver_harga' => encrypt(number_format($row->mst_maxim_driver_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_maxim_driver_admin' => encrypt(number_format($row->mst_maxim_driver_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_maxim_driver_total' => encrypt(number_format($row->mst_maxim_driver_harga + $row->mst_maxim_driver_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_maxim_driver_poin' => encrypt($row->mst_maxim_driver_poin, $this->config->item('key')),
					'mst_maxim_driver_urutan' => encrypt($row->mst_maxim_driver_urutan, $this->config->item('key')),
					'mst_maxim_driver_status' => encrypt($row->mst_maxim_driver_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
