<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_ovo_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$ovo = $this->db->query("SELECT * FROM tbl_mst_ovo  order by mst_ovo_urutan asc");

		if ($ovo->num_rows() > 0) {
			foreach ($ovo->result() as $row) {
				$data['ovo'][] = array(
					'mst_ovo_kode' => encrypt($row->mst_ovo_kode, $this->config->item('key')),
					'mst_ovo_nama' => encrypt($row->mst_ovo_nama, $this->config->item('key')),
					'mst_ovo_keterangan' => encrypt($row->mst_ovo_keterangan, $this->config->item('key')),
					'mst_ovo_notasi' => encrypt($row->mst_ovo_notasi, $this->config->item('key')),
					'mst_ovo_harga' => encrypt(number_format($row->mst_ovo_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_ovo_admin' => encrypt(number_format($row->mst_ovo_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_ovo_total' => encrypt(number_format($row->mst_ovo_harga + $row->mst_ovo_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_ovo_poin' => encrypt($row->mst_ovo_poin, $this->config->item('key')),
					'mst_ovo_urutan' => encrypt($row->mst_ovo_urutan, $this->config->item('key')),
					'mst_ovo_status' => encrypt($row->mst_ovo_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
