<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_pulsa_transfer_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$mst_pulsa_transfer_operator = $this->mst_pulsa_transfer_operator();

		//PANGGIL DATA
		$pulsa_transfer = $this->db->query("SELECT * FROM tbl_mst_pulsa_transfer WHERE mst_pulsa_transfer_operator='$mst_pulsa_transfer_operator' order by mst_pulsa_transfer_urutan asc");

		if ($pulsa_transfer->num_rows() > 0) {
			foreach ($pulsa_transfer->result() as $row) {
				$data['pulsa_transfer'][] = array(
					'mst_pulsa_transfer_kode' => encrypt($row->mst_pulsa_transfer_kode, $this->config->item('key')),
					'mst_pulsa_transfer_operator' => encrypt($row->mst_pulsa_transfer_operator, $this->config->item('key')),
					'mst_pulsa_transfer_nama' => encrypt($row->mst_pulsa_transfer_nama, $this->config->item('key')),
					'mst_pulsa_transfer_keterangan' => encrypt($row->mst_pulsa_transfer_keterangan, $this->config->item('key')),
					'mst_pulsa_transfer_notasi' => encrypt($row->mst_pulsa_transfer_notasi, $this->config->item('key')),
					'mst_pulsa_transfer_harga' => encrypt(number_format($row->mst_pulsa_transfer_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_pulsa_transfer_admin' => encrypt(number_format($row->mst_pulsa_transfer_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_pulsa_transfer_total' => encrypt(number_format($row->mst_pulsa_transfer_harga + $row->mst_pulsa_transfer_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_pulsa_transfer_poin' => encrypt($row->mst_pulsa_transfer_poin, $this->config->item('key')),
					'mst_pulsa_transfer_urutan' => encrypt($row->mst_pulsa_transfer_urutan, $this->config->item('key')),
					'mst_pulsa_transfer_status' => encrypt($row->mst_pulsa_transfer_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_pulsa_transfer_operator()
	{
		$input = decrypt($this->input->post("mst_pulsa_transfer_operator", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
