<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_sakuku_activity_riwayat extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//PAGING
		$page_number = $this->input->post("page_number", true);
		$paging = $page_number * 10 - (10);
		if ($paging == '1') {
			$paging = 0;
		}

		//FILTER
		$trx_sakuku_tanggal_awal = $this->trx_sakuku_tanggal_awal();
		$trx_sakuku_tanggal_akhir = $this->trx_sakuku_tanggal_akhir();

		//FILTER
		if (strlen($trx_sakuku_tanggal_awal) > 1 && strlen($trx_sakuku_tanggal_akhir) > 1) {
			//PANGGIL DATA
			$sakuku = $this->db->query("SELECT * FROM tbl_trx_sakuku WHERE 
								trx_sakuku_user_kode='$mst_user_kode' AND
								trx_sakuku_tanggal BETWEEN '$trx_sakuku_tanggal_awal 00:00:00' and '$trx_sakuku_tanggal_akhir 23:59:59'
								ORDER BY trx_sakuku_id desc
								limit 20 offset $paging");
		} else {
			//PANGGIL DATA
			$sakuku = $this->db->query("SELECT * FROM tbl_trx_sakuku WHERE 
								trx_sakuku_user_kode='$mst_user_kode'
								ORDER BY trx_sakuku_id desc
								limit 20 offset $paging");
		}

		if ($sakuku->num_rows() > 0) {
			foreach ($sakuku->result() as $row) {
				$data['riwayat'][] = array(
					'trx_sakuku_kode' => encrypt($row->trx_sakuku_kode, $this->config->item('key')),
					'trx_sakuku_user_kode' => encrypt($row->trx_sakuku_user_kode, $this->config->item('key')),
					'trx_sakuku_nomor' => encrypt($row->trx_sakuku_nomor, $this->config->item('key')),
					'trx_sakuku_nama' => encrypt($row->trx_sakuku_nama, $this->config->item('key')),
					'trx_sakuku_admin' => encrypt(number_format($row->trx_sakuku_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_sakuku_harga' => encrypt(number_format($row->trx_sakuku_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_sakuku_total' => encrypt(number_format($row->trx_sakuku_admin + $row->trx_sakuku_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_sakuku_poin' => encrypt($row->trx_sakuku_poin, $this->config->item('key')),
					'trx_sakuku_sn' => encrypt($row->trx_sakuku_sn, $this->config->item('key')),
					'trx_sakuku_keterangan' => encrypt($row->trx_sakuku_keterangan, $this->config->item('key')),
					'trx_sakuku_notasi' => encrypt($row->trx_sakuku_notasi, $this->config->item('key')),
					'trx_sakuku_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_sakuku_tanggal)), $this->config->item('key')),
					'trx_sakuku_icon' => encrypt($row->trx_sakuku_icon, $this->config->item('key')),
					'trx_sakuku_rc' => encrypt($row->trx_sakuku_rc, $this->config->item('key')),
					'trx_sakuku_status' => encrypt($row->trx_sakuku_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal menampilkan data, silahkan refresh halaman secara berkala atau hubungi customer service jika masih terjadi kendala!";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_sakuku_tanggal_awal()
	{
		$input = decrypt($this->input->post("trx_sakuku_tanggal_awal", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_sakuku_tanggal_akhir()
	{
		$input = decrypt($this->input->post("trx_sakuku_tanggal_akhir", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
