<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_harga extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function kategori_post()
	{
		date_default_timezone_set("Asia/Jakarta");

		//PRODUK
		$json_data = file_get_contents('php://input');
		$data = json_decode($json_data, true);
		$produk =  str_replace("-", " ", $data['produk']);

		//PANGGIL PRODUK
		if ($produk == "Pulsa") {
			$produk = $this->db->query("SELECT mst_pulsa_operator as kategori from tbl_mst_pulsa group by mst_pulsa_operator")->result();
		} else if ($produk == "Paket Data") {
			$produk = $this->db->query("SELECT mst_paket_data_operator as kategori from tbl_mst_paket_data group by mst_paket_data_operator")->result();
		} else if ($produk == "Paket Nelfon") {
			$produk = $this->db->query("SELECT mst_paket_nelfon_operator as kategori from tbl_mst_paket_nelfon group by mst_paket_nelfon_operator")->result();
		} else if ($produk == "Paket SMS") {
			$produk = $this->db->query("SELECT mst_paket_sms_operator as kategori from tbl_mst_paket_sms group by mst_paket_sms_operator")->result();
		} else if ($produk == "Masa Aktif") {
			$produk = $this->db->query("SELECT mst_masa_aktif_operator as kategori from tbl_mst_masa_aktif group by mst_masa_aktif_operator")->result();
		} else if ($produk == "Pulsa Transfer") {
			$produk = $this->db->query("SELECT mst_pulsa_transfer_operator as kategori from tbl_mst_pulsa_transfer group by mst_pulsa_transfer_operator")->result();
		} else if ($produk == "Game") {
			$produk = $this->db->query("SELECT mst_game_kategori as kategori from tbl_mst_game group by mst_game_kategori")->result();
		} else {
			$produk = array();
		}

		if (count($produk) > 0) {
			foreach ($produk as $row) {
				$data['data'][] = array(
					'kategori' => $row->kategori,
				);
			}
			$data['status'] = "1";
			echo json_encode($data);
		} else {
			$data['data'][] = array(
				'kategori' => "Tidak ada kategori",
			);
			$data['status'] = "0";
			echo json_encode($data);
		}
	}

	public function detail_post()
	{
		date_default_timezone_set("Asia/Jakarta");

		//PRODUK
		$json_data = file_get_contents('php://input');
		$data = json_decode($json_data, true);

		$produk = $data['produk'];
		$kategori = $data['kategori'];

		//PANGGIL PRODUK
		if ($produk == "Pulsa") {
			$kategori_produk = $this->db->query("SELECT
								 mst_pulsa_nama as nama,
								 mst_pulsa_admin as admin,
								 mst_pulsa_harga as harga
								 from tbl_mst_pulsa 
								 where mst_pulsa_operator='$kategori'")->result();
		} else if ($produk == "Paket Data") {
			$kategori_produk = $this->db->query("SELECT
								 mst_paket_data_nama as nama,
								 mst_paket_data_admin as admin,
								 mst_paket_data_harga as harga
								 from tbl_mst_paket_data 
								 where mst_paket_data_operator='$kategori'")->result();
		} else if ($produk == "Paket Nelfon") {
			$kategori_produk = $this->db->query("SELECT
								 mst_paket_nelfon_nama as nama,
								 mst_paket_nelfon_admin as admin,
								 mst_paket_nelfon_harga as harga
								 from tbl_mst_paket_nelfon
								 where mst_paket_nelfon_operator='$kategori'")->result();
		} else if ($produk == "Paket SMS") {
			$kategori_produk = $this->db->query("SELECT
								 mst_paket_sms_nama as nama,
								 mst_paket_sms_admin as admin,
								 mst_paket_sms_harga as harga
								 from tbl_mst_paket_sms
								 where mst_paket_sms_operator='$kategori'")->result();
		} else if ($produk == "Masa Aktif") {
			$kategori_produk = $this->db->query("SELECT
								 mst_masa_aktif_nama as nama,
								 mst_masa_aktif_admin as admin,
								 mst_masa_aktif_harga as harga
								 from tbl_mst_masa_aktif
								 where mst_masa_aktif_operator='$kategori'")->result();
		} else if ($produk == "Pulsa Transfer") {
			$kategori_produk = $this->db->query("SELECT
								 mst_pulsa_transfer_nama as nama,
								 mst_pulsa_transfer_admin as admin,
								 mst_pulsa_transfer_harga as harga
								 from tbl_mst_pulsa_transfer
								 where mst_pulsa_transfer_operator='$kategori'")->result();
		} else if ($produk == "Game") {
			$kategori_produk = $this->db->query("SELECT
								mst_game_nama as nama,
								mst_game_admin as admin,
								mst_game_harga as harga
								from tbl_mst_game
								where mst_game_kategori='$kategori'")->result();
		} else if ($produk == "Gopay") {
			$kategori_produk = $this->db->query("SELECT
								mst_gopay_nama as nama,
								mst_gopay_admin as admin,
								mst_gopay_harga as harga
								from tbl_mst_gopay ")->result();
		} else if ($produk == "OVO") {
			$kategori_produk = $this->db->query("SELECT
								mst_ovo_nama as nama,
								mst_ovo_admin as admin,
								mst_ovo_harga as harga
								from tbl_mst_ovo")->result();
		} else if ($produk == "LinkAja") {
			$kategori_produk = $this->db->query("SELECT
								mst_linkaja_nama as nama,
								mst_linkaja_admin as admin,
								mst_linkaja_harga as harga
								from tbl_mst_linkaja")->result();
		} else if ($produk == "Maxim") {
			$kategori_produk = $this->db->query("SELECT
								mst_maxim_nama as nama,
								mst_maxim_admin as admin,
								mst_maxim_harga as harga
								from tbl_mst_maxim")->result();
		} else if ($produk == "Dana") {
			$kategori_produk = $this->db->query("SELECT
								mst_dana_nama as nama,
								mst_dana_admin as admin,
								mst_dana_harga as harga
								from tbl_mst_dana")->result();
		} else if ($produk == "Shopeepay") {
			$kategori_produk = $this->db->query("SELECT
								mst_shopeepay_nama as nama,
								mst_shopeepay_admin as admin,
								mst_shopeepay_harga as harga
								from tbl_mst_shopeepay")->result();
		} else if ($produk == "Doku") {
			$kategori_produk = $this->db->query("SELECT
								mst_doku_nama as nama,
								mst_doku_admin as admin,
								mst_doku_harga as harga
								from tbl_mst_doku")->result();
		} else if ($produk == "Grab") {
			$kategori_produk = $this->db->query("SELECT
								mst_grab_nama as nama,
								mst_grab_admin as admin,
								mst_grab_harga as harga
								from tbl_mst_grab")->result();
		} else if ($produk == "Sakuku") {
			$kategori_produk = $this->db->query("SELECT
								mst_sakuku_nama as nama,
								mst_sakuku_admin as admin,
								mst_sakuku_harga as harga
								from tbl_mst_sakuku")->result();
		} else if ($produk == "i-saku") {
			$kategori_produk = $this->db->query("SELECT
								mst_isaku_nama as nama,
								mst_isaku_admin as admin,
								mst_isaku_harga as harga
								from tbl_mst_isaku")->result();
		} else if ($produk == "Gojek Driver") {
			$kategori_produk = $this->db->query("SELECT
								mst_gojek_driver_nama as nama,
								mst_gojek_driver_admin as admin,
								mst_gojek_driver_harga as harga
								from tbl_mst_gojek_driver")->result();
		} else if ($produk == "Maxim Driver") {
			$kategori_produk = $this->db->query("SELECT
								mst_maxim_driver_nama as nama,
								mst_maxim_driver_admin as admin,
								mst_maxim_driver_harga as harga
								from tbl_mst_maxim_driver")->result();
		} else if ($produk == "Grab Driver") {
			$kategori_produk = $this->db->query("SELECT
								mst_grab_driver_nama as nama,
								mst_grab_driver_admin as admin,
								mst_grab_driver_harga as harga
								from tbl_mst_grab_driver")->result();
		} else if ($produk == "Shopee Driver") {
			$kategori_produk = $this->db->query("SELECT
								mst_shopee_driver_nama as nama,
								mst_shopee_driver_admin as admin,
								mst_shopee_driver_harga as harga
								from tbl_mst_shopee_driver")->result();
		} else if ($produk == "Indomaret") {
			$kategori_produk = $this->db->query("SELECT
								mst_indomaret_nama as nama,
								mst_indomaret_admin as admin,
								mst_indomaret_harga as harga
								from tbl_mst_indomaret")->result();
		} else if ($produk == "Alfamart") {
			$kategori_produk = $this->db->query("SELECT
								mst_alfamart_nama as nama,
								mst_alfamart_admin as admin,
								mst_alfamart_harga as harga
								from tbl_mst_alfamart")->result();
		} else if ($produk == "Tokopedia") {
			$kategori_produk = $this->db->query("SELECT
								mst_tokopedia_nama as nama,
								mst_tokopedia_admin as admin,
								mst_tokopedia_harga as harga
								from tbl_mst_tokopedia")->result();
		} else if ($produk == "Materai") {
			$kategori_produk = $this->db->query("SELECT
								mst_materai_nama as nama,
								mst_materai_admin as admin,
								mst_materai_harga as harga
								from tbl_mst_materai")->result();
		} else if ($produk == "Traveloka") {
			$kategori_produk = $this->db->query("SELECT
								mst_traveloka_nama as nama,
								mst_traveloka_admin as admin,
								mst_traveloka_harga as harga
								from tbl_mst_traveloka")->result();
		} else if ($produk == "M-TIX") {
			$kategori_produk = $this->db->query("SELECT
								mst_mtix_nama as nama,
								mst_mtix_admin as admin,
								mst_mtix_harga as harga
								from tbl_mst_mtix")->result();
		} else if ($produk == "TIX-ID") {
			$kategori_produk = $this->db->query("SELECT
								mst_tixid_nama as nama,
								mst_tixid_admin as admin,
								mst_tixid_harga as harga
								from tbl_mst_tixid")->result();
		} else if ($produk == "Spotify") {
			$kategori_produk = $this->db->query("SELECT
								mst_spotify_nama as nama,
								mst_spotify_admin as admin,
								mst_spotify_harga as harga
								from tbl_mst_spotify")->result();
		} else if ($produk == "Googleplay") {
			$kategori_produk = $this->db->query("SELECT
								mst_googleplay_nama as nama,
								mst_googleplay_admin as admin,
								mst_googleplay_harga as harga
								from tbl_mst_googleplay")->result();
		} else if ($produk == "Vidio") {
			$kategori_produk = $this->db->query("SELECT
								mst_vidio_nama as nama,
								mst_vidio_admin as admin,
								mst_vidio_harga as harga
								from tbl_mst_vidio")->result();
		} else if ($produk == "Unipin") {
			$kategori_produk = $this->db->query("SELECT
								mst_unipin_nama as nama,
								mst_unipin_admin as admin,
								mst_unipin_harga as harga
								from tbl_mst_unipin")->result();
		} else if ($produk == "WIFI-ID") {
			$kategori_produk = $this->db->query("SELECT
								mst_wifiid_nama as nama,
								mst_wifiid_admin as admin,
								mst_wifiid_harga as harga
								from tbl_mst_wifiid")->result();
		} else if ($produk == "Bukalapak") {
			$kategori_produk = $this->db->query("SELECT
								mst_bukalapak_nama as nama,
								mst_bukalapak_admin as admin,
								mst_bukalapak_harga as harga
								from tbl_mst_bukalapak")->result();
		} else if ($produk == "E-Money") {
			$kategori_produk = $this->db->query("SELECT
								mst_emoney_nama as nama,
								mst_emoney_admin as admin,
								mst_emoney_harga as harga
								from tbl_mst_emoney")->result();
		} else if ($produk == "Tapcash") {
			$kategori_produk = $this->db->query("SELECT
								mst_tapcash_nama as nama,
								mst_tapcash_admin as admin,
								mst_tapcash_harga as harga
								from tbl_mst_tapcash")->result();
		} else if ($produk == "Brizzi") {
			$kategori_produk = $this->db->query("SELECT
								mst_brizzi_nama as nama,
								mst_brizzi_admin as admin,
								mst_brizzi_harga as harga
								from tbl_mst_brizzi")->result();
		} else {
			$kategori_produk = array();
		}



		if (count($kategori_produk) > 0) {
			foreach ($kategori_produk as $row) {
				$data['data'][] = array(
					'nama' => $row->nama,
					'harga' => number_format($row->admin + $row->harga, 0, ',', '.'),
				);
			}
			echo json_encode($data);
		} else {
			$data['data'][] = array(
				'nama' => 'Tidak ada data',
				'harga' => 'Tidak ada data',
			);
			echo json_encode($data);
		}
	}
}
