<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if (!function_exists('send_otp_via_fonnte')) {
    /**
     * Kirim OTP via WhatsApp menggunakan API Fonnte
     * @param string $nomor_hp Nomor HP tujuan
     * @param string $otp Kode OTP yang akan dikirim
     * @param string|null $pesan_custom Pesan custom, jika null akan default format
     * @return array [success=>bool, message=>string, response=>mixed]
     */
    function send_otp_via_fonnte($nomor_hp, $otp, $pesan_custom = null)
    {
        $token = env('FONNTE_TOKEN'); // Ambil token dari .env pakai helper env()
        if (!$token) {
            log_message('error', '[FONNTE OTP ERROR] Fonnte token tidak ditemukan di .env!');
            return ['success'=>false, 'message'=>'Fonnte token tidak ditemukan di .env'];
        }

        

        // Format nomor: +62...
        $nomor = format_wa_number($nomor_hp);

        // Format pesan
        $message = $pesan_custom ?: "Nomor Referensi Anda adalah: $otp\nNomor ini Rahasia. Jangan berikan ini kepada siapa pun. \nBerlaku 5 menit.";

        $data = [
            'target'  => $nomor,
            'message' => $message
        ];

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => 'https://api.fonnte.com/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTPHEADER => [
                "Authorization: $token"
            ]
        ]);
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err) {
            return ['success'=>false, 'message'=>'Curl error: ' . $err, 'response'=>null];
        } else {
            // Cek sukses dari response Fonnte (misal: {"status":true, ...})
            $result = json_decode($response, true);
            if (isset($result['status']) && $result['status']) {
                return ['success'=>true, 'message'=>'OTP berhasil dikirim', 'response'=>$result];
            } else {
                return ['success'=>false, 'message'=>'Gagal kirim OTP: ' . ($result['reason']??'Tidak diketahui'), 'response'=>$result];
            }
        }
    }
}

if (!function_exists('format_wa_number')) {
    /**
     * Format nomor Indonesia ke +62...
     */
    function format_wa_number($nomor)
    {
        $nomor = preg_replace('/\D/', '', $nomor); // hanya angka
        if (substr($nomor, 0, 1) === '0') {
            $nomor = '+62' . substr($nomor, 1);
        } elseif (substr($nomor, 0, 2) === '62') {
            $nomor = '+'.$nomor;
        } elseif (substr($nomor, 0, 1) !== '+') {
            $nomor = '+'.$nomor;
        }
        return $nomor;
    }
}
