<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * key_helper
 *
 * Membaca KEY dan KEYTOKEN dari environment (.env) via env_helper,
 * atau fallback ke config item jika belum tersedia.
 *
 * Usage di controller:
 *   $this->load->helper('env_helper');
 *   $this->load->helper('key_helper');
 *   $key      = get_key();
 *   $keytoken = get_keytoken();
 */

/**
 * Ambil kunci enkripsi utama dari ENV atau config.
 *
 * @return string
 */
if (! function_exists('get_key')) {
    function get_key()
    {
        // Pertama coba ambil dari .env (env_helper)
        $key = env('KEY', null);
        if ($key) {
            return $key;
        }
        // Jika tidak, coba dari application/config/config.php
        $CI =& get_instance();
        $key = $CI->config->item('KEY');
        if ($key) {
            return $key;
        }
        // Jika tetap kosong, hentikan dengan error
        show_error('Environment variable KEY tidak ditemukan', 500);
    }
}

/**
 * Ambil kunci token (untuk enkripsi token jika dibutuhkan).
 *
 * @return string
 */
if (! function_exists('get_keytoken')) {
    function get_keytoken()
    {
        // Dari .env
        $kt = env('KEYTOKEN', null);
        if ($kt) {
            return $kt;
        }
        // Dari config
        $CI =& get_instance();
        $kt = $CI->config->item('KEYTOKEN');
        if ($kt) {
            return $kt;
        }
        show_error('Environment variable KEYTOKEN tidak ditemukan', 500);
    }
}
