<?php
defined('BASEPATH') or exit('No direct script access allowed');

if (!function_exists('log_api_event')) {
    function log_api_event($ref_id, $type, $data, $label = '', $source = '')
    {
        $CI = &get_instance();

        $log = [
            'time'     => date('Y-m-d H:i:s'),
            'ref_id'   => $ref_id,
            'type'     => strtoupper($type),
            'label'    => $label,
            'source'   => $source,
            'url'      => current_url(),
            'method'   => $_SERVER['REQUEST_METHOD'] ?? 'UNKNOWN',
            'ip'       => $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN',
            'body'     => is_array($data) ? $data : @json_decode($data, true) ?? $data
        ];

        log_message('info', "[API-TRACE] " . json_encode($log));
    }
}
