<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends CI_Model
{
    protected $table = 'tbl_mst_user';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Ambil satu user berdasarkan nomor HP
     * @param string $nomor_hp
     * @return array|null
     */
    public function get_by_nomor_hp($nomor_hp)
    {
        return $this->db
                    ->where('mst_user_nomor_hp', $nomor_hp)
                    ->get($this->table)
                    ->row_array();
    }

    /**
     * Insert user baru
     * @param array $data Associative array field => value
     * @return int|false Insert ID jika sukses, false jika gagal
     */
    public function insert_user($data)
    {
        if (!$this->db->insert($this->table, $data)) {
            return false;
        }
        return $this->db->insert_id();
    }

    public function update_token($kode, $token)
    {
        return $this->db
                    ->where('mst_user_kode', $kode)
                    ->update($this->table, ['mst_user_token' => $token]);
    }
}

